/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.utils;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserNameUtils {
    public static String lookupGrid1Environment(String browserString) {
        String translatedBrowserString = Hub.getGrid1Mapping().get(browserString);
        return translatedBrowserString == null ? browserString : translatedBrowserString;
    }

    public static Map<String, Object> parseGrid2Environment(String environment) {
        HashMap ret = Maps.newHashMap();
        String[] details = environment.split(" ");
        if (details.length == 1) {
            ret.put("browserName", details[0]);
        } else {
            ret.put("browserName", details[0]);
            if (details.length == 3) {
                ret.put("platform", Platform.extractFromSysProperty((String)details[2]));
            }
        }
        return ret;
    }

    public static String consoleIconName(DesiredCapabilities cap) {
        String browserString = cap.getBrowserName();
        if (browserString == null || "".endsWith(browserString)) {
            return "missingBrowserName";
        }
        String ret = browserString;
        if (browserString.charAt(0) != '*') {
            browserString = BrowserNameUtils.lookupGrid1Environment(browserString);
        }
        if (browserString.contains("iexplore") || browserString.startsWith("*iehta")) {
            ret = "internet explorer";
        } else if (browserString.contains("firefox") || browserString.startsWith("*chrome")) {
            ret = cap.getVersion() != null && cap.getVersion().startsWith("6") ? "aurora" : "firefox";
        } else if (browserString.startsWith("*safari")) {
            ret = "safari";
        } else if (browserString.startsWith("*googlechrome")) {
            ret = "chrome";
        } else if (browserString.startsWith("opera")) {
            ret = "opera";
        }
        return ret;
    }

    public static String getConsoleIconPath(DesiredCapabilities cap) {
        String name = BrowserNameUtils.consoleIconName(cap);
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("images/" + name + ".png");
        if (in == null) {
            return null;
        }
        return "/grid/resources/images/" + name + ".png";
    }
}

