/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.grid.web.servlet.handler.RequestHandler;

public class ConsoleServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    private static final Logger log = Logger.getLogger(ConsoleServlet.class.getName());
    private static String coreVersion;
    private static String coreRevision;

    public ConsoleServlet() {
        this(null);
    }

    public ConsoleServlet(Registry registry) {
        super(registry);
        this.getVersion();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<title>Grid overview</title>");
        builder.append("<style>");
        builder.append(".busy {");
        builder.append(" opacity : 0.4;");
        builder.append("filter: alpha(opacity=40);");
        builder.append("}");
        builder.append("</style>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("<H1>Grid Hub ");
        builder.append(coreVersion + "[" + coreRevision + "]");
        builder.append("</H1>");
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            builder.append(proxy.getHtmlRender().renderSummary());
        }
        List<RequestHandler> l = this.getRegistry().getNewSessionRequests();
        if (l.size() != 0) {
            builder.append(l.size() + " requests waiting for a slot to be free.");
        }
        builder.append("<ul>");
        for (RequestHandler req : l) {
            builder.append("<li>" + req.getDesiredCapabilities() + "</li>");
        }
        builder.append("</ul>");
        builder.append("</body>");
        builder.append("</html>");
        ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((InputStream)in).close();
            response.getOutputStream().close();
            throw throwable;
        }
        ((InputStream)in).close();
        response.getOutputStream().close();
    }

    private void getVersion() {
        Properties p = new Properties();
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("VERSION.txt");
        if (stream == null) {
            log.severe("Couldn't determine version number");
            return;
        }
        try {
            p.load(stream);
        }
        catch (IOException e) {
            log.severe("Cannot load version from VERSION.txt" + e.getMessage());
        }
        coreVersion = p.getProperty("selenium.core.version");
        coreRevision = p.getProperty("selenium.core.revision");
        if (coreVersion == null) {
            log.severe("Cannot load selenium.core.version from VERSION.txt");
        }
    }
}

