/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.web.servlet.ConsoleServlet;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.jetty.http.SocketListener;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.WebApplicationContext;
import org.openqa.selenium.net.NetworkUtils;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hub {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private int port;
    private String host;
    private Server server;
    private Registry registry;
    private Map<String, Class<? extends Servlet>> extraServlet = Maps.newHashMap();
    private static Map<String, Integer> grid1Config = Maps.newHashMap();
    private static Map<String, String> grid1Mapping = Maps.newHashMap();
    private static Hub INSTANCE = new Hub(4444, Registry.getInstance());
    private NetworkUtils utils = new NetworkUtils();

    public static Hub getInstance() {
        return INSTANCE;
    }

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public static Hub getNewInstanceForTest(int port, Registry registry) {
        return new Hub(port, registry);
    }

    private Hub(int port, Registry registry) {
        this.host = this.utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        this.port = port;
        this.registry = registry;
        registry.setHub(this);
        this.loadGrid1Config();
    }

    private void initServer() {
        try {
            this.server = new Server();
            SocketListener socketListener = new SocketListener();
            socketListener.setMaxIdleTimeMs(60000);
            socketListener.setPort(this.port);
            this.server.addListener(socketListener);
            WebApplicationContext root = this.server.addWebApplication("", ".");
            root.setAttribute(Registry.KEY, this.registry);
            root.addServlet("/*", DisplayHelpServlet.class.getName());
            root.addServlet("/grid/console/*", ConsoleServlet.class.getName());
            root.addServlet("/grid/register/*", RegistrationServlet.class.getName());
            root.addServlet("/grid/driver/*", DriverServlet.class.getName());
            root.addServlet("/wd/hub/*", DriverServlet.class.getName());
            root.addServlet("/selenium-server/driver/*", DriverServlet.class.getName());
            root.addServlet("/grid/resources/*", ResourceServlet.class.getName());
            root.addServlet("/grid/status/*", ProxyStatusServlet.class.getName());
            root.addServlet("/registration-manager/register/*", RegistrationServlet.class.getName());
            root.addServlet("/heartbeat", Grid1HeartbeatServlet.class.getName());
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getKey(), entry.getValue().getName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub" + e.getMessage(), e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void start() throws Exception {
        this.initServer();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getUrl() {
        try {
            return new URL("http://" + this.getHost() + ":" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        String uri = "http://" + this.getHost() + ":" + this.getPort() + "/grid/register/";
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getGrid1Mapping() {
        return Collections.unmodifiableMap(grid1Mapping);
    }

    public static Map<String, Integer> getGrid1Config() {
        return Collections.unmodifiableMap(grid1Config);
    }

    protected void loadGrid1Config() {
        InputStream input = Class.class.getResourceAsStream("/grid_configuration.yml");
        if (input != null) {
            log.info("Loading Grid 1.0 configuration file.");
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.load(input);
            Map hub = (Map)config.get("hub");
            List environments = (List)hub.get("environments");
            for (Map environment : environments) {
                grid1Mapping.put((String)environment.get("name"), (String)environment.get("browser"));
            }
            Integer cleanupCycle = hub.get("remoteControlPollingIntervalInSeconds") == null ? 180 : (Integer)hub.get("remoteControlPollingIntervalInSeconds");
            grid1Config.put("cleanupCycle", cleanupCycle * 1000);
            Integer timeout = hub.get("sessionMaxIdleTimeInSeconds") == null ? 300 : (Integer)hub.get("sessionMaxIdleTimeInSeconds");
            grid1Config.put("timeout", timeout * 1000);
            grid1Config.put("newSessionWaitTimeout", (Integer)hub.get("newSessionMaxWaitTimeInSeconds") * 1000);
        } else {
            log.info("Did not find a Grid 1.0 configuration file.  Skipping Grid 1.0 setup.");
        }
    }

    public void registerServlets(List<String> servlets) {
        if (servlets == null) {
            return;
        }
        for (String s : servlets) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (s == null) continue;
            String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
            log.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.addServlet(path, servletClass);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }
}

