/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.grid.internal.exception.GridException;
import org.openqa.grid.selenium.utils.GridRole;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridConfiguration {
    private GridRole role = GridRole.NOT_GRID;
    private int timeout = 30;
    private int maxConcurrent = 5;
    private URL registrationURL;
    private int port = 4444;
    private String host;
    private boolean throwOnCapabilityNotPresent = true;
    private String[] seleniumServerargs = new String[0];
    private RemoteControlConfiguration nodeConfig = new RemoteControlConfiguration();
    private NetworkUtils networkUtils = new NetworkUtils();
    private List<String> servlets = new ArrayList<String>();
    private List<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
    private String file;

    public static GridConfiguration parse(String[] args) {
        ArrayList<String> leftOver = new ArrayList<String>();
        GridConfiguration config = new GridConfiguration();
        for (int i = 0; i < args.length; ++i) {
            String v;
            String arg = args[i];
            if ("-role".equalsIgnoreCase(arg)) {
                if ("hub".equalsIgnoreCase(v = GridConfiguration.getArgValue(args, ++i))) {
                    config.setRole(GridRole.HUB);
                    continue;
                }
                if ("remotecontrol".equalsIgnoreCase(v) || "remote-control".equalsIgnoreCase(v) || "rc".equalsIgnoreCase(v)) {
                    config.setRole(GridRole.REMOTE_CONTROL);
                    continue;
                }
                if ("webdriver".equalsIgnoreCase(v) || "wd".equalsIgnoreCase(v)) {
                    config.setRole(GridRole.WEBDRIVER);
                    continue;
                }
                config.setRole(GridRole.NOT_GRID);
                GridConfiguration.printHelpAndDie("wrong role");
                continue;
            }
            if ("-hub".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                try {
                    config.setRegistrationURL(new URL(v));
                }
                catch (MalformedURLException e) {
                    GridConfiguration.printHelpAndDie("invalid url : " + v);
                }
                continue;
            }
            if ("-port".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setPort(Integer.parseInt(v));
                leftOver.add(arg);
                leftOver.add(v);
                continue;
            }
            if ("-host".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setHost(v);
                continue;
            }
            if ("-nodeTimeout".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setNodeTimeoutInSec(Integer.parseInt(v));
                continue;
            }
            if ("-maxConcurrent".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setMaxConcurrentTests(Integer.parseInt(v));
                continue;
            }
            if ("-browser".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.addCapabilityFromString(v);
                continue;
            }
            if ("-servlet".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.addServlet(v);
                continue;
            }
            if ("-throwCapabilityNotPresent".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setThrowOnCapabilityNotPresent(Boolean.parseBoolean(v));
                continue;
            }
            if ("-file".equalsIgnoreCase(arg)) {
                v = GridConfiguration.getArgValue(args, ++i);
                config.setFile(v);
                continue;
            }
            leftOver.add(arg);
        }
        config.setSeleniumServerArgs(leftOver);
        try {
            config.validate();
        }
        catch (InvalidParameterException e) {
            GridConfiguration.printHelpAndDie(e.getMessage());
        }
        return config;
    }

    private void setFile(String v) {
        if (this.role != GridRole.WEBDRIVER) {
            throw new RuntimeException("Setting a file as config for a node is only for webdriver.");
        }
        this.file = v;
    }

    public boolean isThrowOnCapabilityNotPresent() {
        return this.throwOnCapabilityNotPresent;
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public List<String> getServlets() {
        return this.servlets;
    }

    private void addServlet(String v) {
        this.servlets.add(v);
    }

    public List<DesiredCapabilities> getCapabilities() {
        return this.capabilities;
    }

    private void addCapabilityFromString(String capability) {
        String[] s = capability.split(",");
        if (s.length == 0) {
            throw new InvalidParameterException("-browser must be followed by a browser description");
        }
        DesiredCapabilities res = new DesiredCapabilities();
        for (int i = 0; i < s.length; ++i) {
            if (s[i].split("=").length != 2) {
                throw new InvalidParameterException("-browser format is key1=value1,key2=value2 " + s[i] + " deosn't follow that format.");
            }
            String key = s[i].split("=")[0];
            String value = s[i].split("=")[1];
            res.setCapability(key, value);
        }
        if (res.getBrowserName() == null) {
            throw new GridException("You need to specify a browserName using browserName=XXX");
        }
        this.capabilities.add(res);
    }

    private static String getArgValue(String[] args, int i) {
        if (i >= args.length) {
            GridConfiguration.printHelpAndDie("expected a value after " + args[i]);
        }
        return args[i];
    }

    private static void printHelpAndDie(String msg) {
        String INDENT = "  ";
        RemoteControlLauncher.printWrappedErrorLine("", "Error with the parameters :" + msg);
        RemoteControlLauncher.printWrappedErrorLine("", "To use as a grid, specify a role and its arguments.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-role <hub|remotecontrol|webdriver> (default is no grid -- just run an RC server). When launching a node for webdriver or remotecontrol, the parameters will be forwarded to the server on the node, so you can use something like -role remotecontrol -trustAllSSLCertificates. In that case, the SeleniumServer will be launch with the trustallCertificats option.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-hub <http://localhost:4444/grid/register> : the url that will be used to post the registration request.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-host <IP | hostname> : usually not needed and determined automatically. For exotic network configuration, network with VPN, specifying the host might be necessary.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-port <xxxx> : the port the remote/hub will listen on.Default to 4444.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-nodeTimeout <xxxx> : the timeout in seconds before the hub automatically releases a node that hasn't received any requests for more than XX sec. The browser will be released for another test to use.This tupically takes care of the client crashes.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-maxConcurrent <x> : Defaults to 5. The maximum number of tests that can run at the same time on the node. Different from the supported browsers.For a node that supports firefox 3.6, firefox 4.0  and IE8 for instance,maxConccurent=1 will ensure that you never have more than 1 browserrunning. With maxConcurrent=2 you can have 2 firefox tests at the same time, or 1 IE and 1 FF. ");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-servlet <com.mycompany.MyServlet> to register a new servlet on the hub. The servlet will accessible under the path  /grid/admin/MyServlet");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-throwCapabilityNotPresent <true | false> default to true. If true, the hub will reject test request right away if no proxy is currently registered that can host that capability.");
        System.exit(-1);
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.networkUtils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public URL getRegistrationURL() {
        return this.registrationURL;
    }

    public void setRegistrationURL(URL registrationURL) {
        this.registrationURL = registrationURL;
    }

    public GridRole getRole() {
        return this.role;
    }

    public int getPort() {
        return this.port;
    }

    public void setRole(GridRole role) {
        this.role = role;
    }

    public void setPort(int port) {
        this.port = port;
        this.getNodeRemoteControlConfiguration().setPort(port);
    }

    public void validate() {
        if (this.role == GridRole.WEBDRIVER || this.role == GridRole.REMOTE_CONTROL) {
            if (this.registrationURL == null) {
                throw new InvalidParameterException("registration url cannot be null");
            }
            if (this.getNodeRemoteControlConfiguration().isInteractive()) {
                throw new InvalidParameterException("no point launching the node in interactive mode");
            }
        }
    }

    public void setSeleniumServerArgs(List<String> leftOver) {
        this.seleniumServerargs = leftOver.toArray(new String[leftOver.size()]);
        this.nodeConfig = RemoteControlLauncher.parseLauncherOptions(this.seleniumServerargs);
    }

    public RemoteControlConfiguration getNodeRemoteControlConfiguration() {
        return this.nodeConfig;
    }

    public void setNodeTimeoutInSec(int sec) {
        this.timeout = sec;
    }

    public int getNodeTimeoutInSec() {
        return this.timeout;
    }

    public int getMaxConcurrentTests() {
        return this.maxConcurrent;
    }

    public void setMaxConcurrentTests(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
    }

    public String getFile() {
        return this.file;
    }
}

