/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.selenium.server.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptureNetworkTrafficCommand
extends Command {
    private static final List<Entry> entries = Collections.synchronizedList(new ArrayList());
    private String type;

    public static void clear() {
        entries.clear();
    }

    public static void capture(Entry entry) {
        entries.add(entry);
    }

    public CaptureNetworkTrafficCommand(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        if ("json".equalsIgnoreCase(this.type)) {
            sb.append("[");
            List<Entry> list = entries;
            synchronized (list) {
                Iterator<Entry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Entry entry = iterator.next();
                    sb.append("{\n");
                    sb.append(this.jsonKey("statusCode")).append(entry.statusCode).append(",\n");
                    sb.append(this.jsonKey("method")).append(this.json(entry.method)).append(",\n");
                    sb.append(this.jsonKey("url")).append(this.json(entry.url)).append(",\n");
                    sb.append(this.jsonKey("bytes")).append(entry.bytes).append(",\n");
                    sb.append(this.jsonKey("start")).append(this.json(sdf.format(entry.start))).append(",\n");
                    sb.append(this.jsonKey("end")).append(this.json(sdf.format(entry.end))).append(",\n");
                    sb.append(this.jsonKey("timeInMillis")).append(entry.end.getTime() - entry.start.getTime()).append(",\n");
                    sb.append(this.jsonKey("requestHeaders")).append("[");
                    this.jsonHeaders(sb, entry.requestHeaders);
                    sb.append("],\n");
                    sb.append(this.jsonKey("responseHeaders")).append("[");
                    this.jsonHeaders(sb, entry.responseHeaders);
                    sb.append("]\n");
                    sb.append("}");
                    if (!iterator.hasNext()) continue;
                    sb.append(",\n");
                }
            }
            sb.append("]");
        } else if ("xml".equalsIgnoreCase(this.type)) {
            sb.append("<traffic>\n");
            List<Entry> list = entries;
            synchronized (list) {
                for (Entry entry : entries) {
                    sb.append("<entry ");
                    sb.append("statusCode=\"").append(entry.statusCode).append("\" ");
                    sb.append("method=\"").append(this.json(entry.method)).append("\" ");
                    sb.append("url=\"").append(this.xml(entry.url)).append("\" ");
                    sb.append("bytes=\"").append(entry.bytes).append("\" ");
                    sb.append("start=\"").append(sdf.format(entry.start)).append("\" ");
                    sb.append("end=\"").append(sdf.format(entry.end)).append("\" ");
                    sb.append("timeInMillis=\"").append(entry.end.getTime() - entry.start.getTime()).append("\">\n");
                    sb.append("    <requestHeaders>\n");
                    this.xmlHeaders(sb, entry.requestHeaders);
                    sb.append("    </requestHeaders>\n");
                    sb.append("    <responseHeaders>\n");
                    this.xmlHeaders(sb, entry.responseHeaders);
                    sb.append("    </responseHeaders>\n");
                    sb.append("</entry>\n");
                }
            }
            sb.append("</traffic>\n");
        } else {
            List<Entry> list = entries;
            synchronized (list) {
                for (Entry entry : entries) {
                    sb.append(entry.statusCode).append(" ").append(entry.method).append(" ").append(entry.url).append("\n");
                    sb.append(entry.bytes).append(" bytes\n");
                    sb.append(entry.end.getTime() - entry.start.getTime()).append("ms (").append(sdf.format(entry.start)).append(" - ").append(sdf.format(entry.end)).append("\n");
                    sb.append("\n");
                    sb.append("Request Headers\n");
                    for (Header header : entry.requestHeaders) {
                        sb.append(" - ").append(header.name).append(" => ").append(header.value).append("\n");
                    }
                    sb.append("Response Headers\n");
                    for (Header header : entry.responseHeaders) {
                        sb.append(" - ").append(header.name).append(" => ").append(header.value).append("\n");
                    }
                    sb.append("================================================================\n");
                    sb.append("\n");
                }
            }
        }
        CaptureNetworkTrafficCommand.clear();
        return "OK," + sb.toString();
    }

    private void xmlHeaders(StringBuilder sb, List<Header> headers) {
        for (Header header : headers) {
            sb.append("        <header name=\"").append(this.xml(header.name)).append("\">").append(this.xml(header.value)).append("</header>\n");
        }
    }

    private void jsonHeaders(StringBuilder sb, List<Header> headers) {
        Iterator<Header> headItr = headers.iterator();
        while (headItr.hasNext()) {
            Header header = headItr.next();
            sb.append("{\n");
            sb.append("    ").append(this.jsonKey("name")).append(this.json(header.name)).append(",\n");
            sb.append("    ").append(this.jsonKey("value")).append(this.json(header.value)).append("\n");
            if (headItr.hasNext()) {
                sb.append("    },");
                continue;
            }
            sb.append("  }");
        }
    }

    private String xml(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("\\<", "&lt;");
        s = s.replaceAll("\\>", "&gt;");
        return s;
    }

    private String jsonKey(String key) {
        StringBuilder ret = new StringBuilder();
        ret.append("  \"").append(key).append("\"").append(":");
        return ret.toString();
    }

    private Object json(String s) {
        s = s.replaceAll("\\'", "\\\\'");
        s = s.replaceAll("\\\"", "\\\\\"");
        s = s.replaceAll("\n", "\\\\n");
        StringBuilder ret = new StringBuilder();
        ret.append("\"").append(s).append("\"");
        return ret.toString();
    }

    public static class Header {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Entry {
        private String method;
        private String url;
        private int statusCode;
        private Date start;
        private Date end;
        private long bytes;
        private List<Header> requestHeaders = new ArrayList<Header>();
        private List<Header> responseHeaders = new ArrayList<Header>();

        public Entry(String method, String url) {
            this.method = method;
            this.url = url;
            this.start = new Date();
        }

        public void finish(int statusCode, long bytes) {
            this.statusCode = statusCode;
            this.bytes = bytes;
            this.end = new Date();
        }

        public void addRequestHeaders(HttpRequest request) {
            Enumeration names = request.getFieldNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = request.getField(name);
                this.requestHeaders.add(new Header(name, value));
            }
        }

        public void addResponseHeader(HttpResponse response) {
            Enumeration names = response.getFieldNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = response.getField(name);
                this.responseHeaders.add(new Header(name, value));
            }
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public String toString() {
            return this.method + "|" + this.statusCode + "|" + this.url + "|" + this.requestHeaders.size() + "|" + this.responseHeaders.size() + "\n";
        }

        public void addRequestHeader(String key, String value) {
            this.requestHeaders.add(new Header(key, value));
        }
    }
}

