/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.internal.Trace;
import org.openqa.selenium.internal.TraceFactory;

public class HtmlIdentifier {
    static Trace log = TraceFactory.getTrace(HtmlIdentifier.class);
    private static List<Rule> rules = new ArrayList<Rule>();
    private static final int INJECTION_THRESHOLD = 200;

    public static boolean shouldBeInjected(String path, String contentType, String contentPreview) {
        int score = 0;
        log.debug("shouldBeInjected(\"" + path + "\", \"" + contentType + "\", \"...\")");
        for (Rule rule : rules) {
            int scoreDelta = rule.score(path, contentType, contentPreview);
            log.debug("    applied rule " + rule + ": " + scoreDelta);
            score += scoreDelta;
        }
        boolean shouldInject = score > 200;
        log.debug("    total : " + score + ">" + 200 + "?  (should " + (shouldInject ? "" : "not ") + "inject)");
        return shouldInject;
    }

    static {
        rules.add(new ExtensionRule(new String[]{"html", "htm"}, 10000));
        rules.add(new ExtensionRule(new String[]{"jsp", "asp", "php", "pl"}, 100));
        rules.add(new ExtensionRule(new String[]{"dll", "js"}, -1000));
        rules.add(new ExtensionRule(new String[]{"gif", "ico", "jpg", "jpeg", "png", "dwr", "swf"}, -10000));
        rules.add(new ContentRule("<html", 1000, -100));
        rules.add(new ContentRule("<head", 500, -100));
        rules.add(new ContentRule("<!DOCTYPE html", 1000, -100));
        rules.add(new ContentTypeRule("text/html", 100, -1000));
        rules.add(new ContentTypeRule("application/java-archive", -20000, 0));
        rules.add(new Rule("dojo catcher", -100000, 0){

            public int score(String path, String contentType, String contentPreview) {
                if (path == null) {
                    return 0;
                }
                if (path.contains("/dojo/")) {
                    return -100000;
                }
                return 0;
            }
        });
    }

    static class ContentTypeRule
    extends Rule {
        String type;

        public ContentTypeRule(String type, int score, int missingScore) {
            super("content type " + type, score, missingScore);
            this.type = type;
        }

        public int score(String path, String contentType, String contentPreview) {
            if (contentType == null) {
                return 0;
            }
            if (contentType.contains(this.type)) {
                return this.score;
            }
            return this.missingScore;
        }
    }

    static class ContentRule
    extends Rule {
        String contentInLowerCase;

        public ContentRule(String content, int score, int missingScore) {
            super("content " + content, score, missingScore);
            this.contentInLowerCase = content.toLowerCase();
        }

        public int score(String path, String contentType, String contentPreview) {
            if (contentPreview == null) {
                return 0;
            }
            if (contentPreview.toLowerCase().contains(this.contentInLowerCase)) {
                return this.score;
            }
            return this.missingScore;
        }
    }

    static class ExtensionRule
    extends Rule {
        List<String> exts = new ArrayList<String>();

        public ExtensionRule(String ext, int score) {
            super("extension " + ext, score, 0);
            this.exts.add(ext);
        }

        public ExtensionRule(String[] ext, int score) {
            super(null, score, 0);
            for (String s : ext) {
                this.exts.add(s);
            }
            this.name = "extension " + this.exts;
        }

        public int score(String path, String contentType, String contentPreview) {
            if (path == null || !path.contains(".")) {
                return 0;
            }
            for (String ext : this.exts) {
                if (!path.endsWith("." + ext)) continue;
                return this.score;
            }
            return 0;
        }
    }

    static abstract class Rule {
        protected final int missingScore;
        protected final int score;
        protected String name;

        public Rule(String name, int score, int missingScore) {
            this.name = name;
            this.score = score;
            this.missingScore = missingScore;
        }

        abstract int score(String var1, String var2, String var3);

        public String toString() {
            return "[" + this.name + " rule: match=" + this.score + (this.missingScore == 0 ? "" : ", failure to match -> " + this.missingScore) + "]";
        }
    }
}

