/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class ElementEquality
extends WebElementHandler {
    private volatile String otherId;
    private volatile Response response;

    public ElementEquality(DriverSessions sessions) {
        super(sessions);
    }

    public void setOther(String otherId) {
        this.otherId = otherId;
    }

    public ResultType call() throws Exception {
        this.response = this.newResponse();
        WebElement one = this.getElement();
        WebElement two = this.getKnownElements().get(this.otherId);
        if (one instanceof WrapsElement) {
            one = ((WrapsElement)one).getWrappedElement();
        }
        if (two instanceof KnownElements.ProxiedElement) {
            two = ((KnownElements.ProxiedElement)two).getWrappedElement();
        }
        this.response.setValue((Object)one.equals(two));
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[equals: %s, %s]", this.getElementAsString(), this.otherId);
    }
}

