/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteScript
extends WebDriverHandler
implements JsonParametersAware {
    private Response response;
    private String script;
    private List<Object> args = new ArrayList<Object>();

    public ExecuteScript(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.script = (String)allParameters.get("script");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList((Iterable)Iterables.transform((Iterable)params, (Function)new ArgumentConverter()));
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)this.getDriver()).executeScript(this.script, this.args.toArray()) : ((JavascriptExecutor)this.getDriver()).executeScript(this.script, new Object[0]);
        Object result = new ResultConverter().apply(value);
        this.response.setValue(result);
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[execute script: %s, %s]", this.script, this.args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultConverter
    implements Function<Object, Object> {
        private ResultConverter() {
        }

        public Object apply(Object result) {
            if (result instanceof WebElement) {
                String elementId = ExecuteScript.this.getKnownElements().add((WebElement)result);
                return ImmutableMap.of((Object)"ELEMENT", (Object)elementId);
            }
            if (result instanceof List) {
                List resultAsList = (List)result;
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)resultAsList, (Function)this));
            }
            if (result instanceof Map) {
                Map resultAsMap = (Map)result;
                HashMap converted = Maps.newHashMapWithExpectedSize((int)resultAsMap.size());
                for (Map.Entry entry : resultAsMap.entrySet()) {
                    converted.put(entry.getKey(), this.apply(entry.getValue()));
                }
                return converted;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentConverter
    implements Function<Object, Object> {
        private ArgumentConverter() {
        }

        public Object apply(Object arg) {
            if (arg instanceof Map) {
                Map paramAsMap = (Map)arg;
                if (paramAsMap.containsKey("ELEMENT")) {
                    KnownElements.ProxiedElement element = (KnownElements.ProxiedElement)ExecuteScript.this.getKnownElements().get((String)paramAsMap.get("ELEMENT"));
                    return element.getWrappedElement();
                }
                HashMap converted = Maps.newHashMapWithExpectedSize((int)paramAsMap.size());
                for (Map.Entry entry : paramAsMap.entrySet()) {
                    converted.put(entry.getKey(), this.apply(entry.getValue()));
                }
                return converted;
            }
            if (arg instanceof List) {
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((List)arg), (Function)this));
            }
            return arg;
        }
    }
}

