/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.SnapshotScreenListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private final WebDriver driver;
    private KnownElements knownElements = new KnownElements();
    private Capabilities capabilities;
    private Executor executor = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private volatile String base64EncodedImage;

    public Session(final DriverFactory factory, final Capabilities capabilities) throws Exception {
        FutureTask<WebDriver> createBrowser = new FutureTask<WebDriver>(new Callable<WebDriver>(){

            @Override
            public WebDriver call() throws Exception {
                WebDriver rawDriver = factory.newInstance(capabilities);
                if (rawDriver instanceof RemoteWebDriver) {
                    Session.this.describe(rawDriver, ((RemoteWebDriver)rawDriver).getCapabilities());
                } else {
                    Session.this.describe(rawDriver, capabilities);
                }
                EventFiringWebDriver driver = new EventFiringWebDriver(rawDriver);
                driver.register((WebDriverEventListener)new SnapshotScreenListener(Session.this));
                return driver;
            }
        });
        this.execute(createBrowser);
        this.driver = createBrowser.get();
    }

    public <X> X execute(FutureTask<X> future) throws Exception {
        this.executor.execute(future);
        return future.get();
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public KnownElements getKnownElements() {
        return this.knownElements;
    }

    public Capabilities getCapabilities() {
        if (this.driver instanceof RemoteWebDriver) {
            return ((RemoteWebDriver)this.driver).getCapabilities();
        }
        return this.capabilities;
    }

    public void attachScreenshot(String base64EncodedImage) {
        this.base64EncodedImage = base64EncodedImage;
    }

    public String getAndClearScreenshot() {
        String temp = this.base64EncodedImage;
        this.base64EncodedImage = null;
        return temp;
    }

    private void describe(WebDriver instance, Capabilities capabilities) {
        DesiredCapabilities caps = new DesiredCapabilities(capabilities.asMap());
        caps.setJavascriptEnabled(instance instanceof JavascriptExecutor);
        if (instance instanceof TakesScreenshot) {
            caps.setCapability("takesScreenshot", true);
        }
        this.capabilities = caps;
    }
}

