/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers.locators;

import java.io.File;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.SystemUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.BrowserLocator;

public abstract class SingleBrowserLocator
implements BrowserLocator {
    private static final Log LOGGER = LogFactory.getLog(BrowserLocator.class);

    public BrowserInstallation findBrowserLocationOrFail() {
        BrowserInstallation location = this.findBrowserLocation();
        if (null == location) {
            throw new RuntimeException(this.couldNotFindAnyInstallationMessage());
        }
        return location;
    }

    public BrowserInstallation findBrowserLocation() {
        BrowserInstallation defaultPath;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Discovering " + this.browserName() + "..."));
        }
        if (null != (defaultPath = this.findAtADefaultLocation())) {
            return defaultPath;
        }
        return this.findInPath();
    }

    protected abstract String browserName();

    protected abstract String[] standardlauncherFilenames();

    protected abstract String seleniumBrowserName();

    protected abstract String browserPathOverridePropertyName();

    protected abstract String[] usualLauncherLocations();

    protected BrowserInstallation findInPath() {
        for (String launcherFilename : this.standardlauncherFilenames()) {
            BrowserInstallation launcherPath = this.findFileInPath(launcherFilename);
            if (null == launcherPath) continue;
            return launcherPath;
        }
        return null;
    }

    protected BrowserInstallation findAtADefaultLocation() {
        return this.browserDefaultPath();
    }

    protected BrowserInstallation browserDefaultPath() {
        String userProvidedDefaultPath = System.getProperty(this.browserPathOverridePropertyName());
        if (null != userProvidedDefaultPath) {
            return this.retrieveValidInstallationPath(userProvidedDefaultPath);
        }
        for (String location : this.usualLauncherLocations()) {
            for (String fileName : this.standardlauncherFilenames()) {
                BrowserInstallation validInstallationPath = this.retrieveValidInstallationPath(location, fileName);
                if (null == validInstallationPath) continue;
                return validInstallationPath;
            }
        }
        return null;
    }

    public BrowserInstallation findFileInPath(String fileName) {
        return this.retrieveValidInstallationPath(AsyncExecute.whichExec(fileName));
    }

    protected String couldNotFindAnyInstallationMessage() {
        return this.browserName() + " could not be found in the path!\n" + "Please add the directory containing '" + this.humanFriendlyLauncherFileNames() + "' to your PATH environment\n" + "variable, or explicitly specify a path to " + this.browserName() + " like this:\n" + "*" + this.seleniumBrowserName() + this.fakeLauncherPath();
    }

    protected String fakeLauncherPath() {
        if (WindowsUtils.thisIsWindows()) {
            return "c:\\blah\\" + this.standardlauncherFilenames()[0];
        }
        return "/blah/blah/" + this.standardlauncherFilenames()[0];
    }

    protected String humanFriendlyLauncherFileNames() {
        String[] fileNames = this.standardlauncherFilenames();
        if (0 == fileNames.length) {
            return "";
        }
        if (1 == fileNames.length) {
            return "'" + fileNames[0] + "'";
        }
        StringBuffer buffer = new StringBuffer();
        for (String filename : fileNames) {
            buffer.append("'").append(filename).append("'");
            buffer.append(" or ");
        }
        return buffer.substring(0, buffer.lastIndexOf(" or "));
    }

    protected BrowserInstallation retrieveValidInstallationPath(String dirname, String fileName) {
        return this.retrieveValidInstallationPath(new File(dirname, fileName));
    }

    public BrowserInstallation retrieveValidInstallationPath(String launcher) {
        if (null == launcher) {
            return null;
        }
        return this.retrieveValidInstallationPath(new File(launcher));
    }

    protected BrowserInstallation retrieveValidInstallationPath(File launcher) {
        if (null == launcher) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking whether " + this.browserName() + " launcher at :'" + launcher + "' is valid..."));
        }
        if (!launcher.exists()) {
            return null;
        }
        if (LauncherUtils.isScriptFile(launcher)) {
            LOGGER.warn((Object)("Caution: '" + launcher.getAbsolutePath() + "': file is a script file, not a real executable.  The browser environment is no longer fully under RC control"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Discovered valid " + this.browserName() + " launcher  : '" + launcher + "'"));
        }
        return new BrowserInstallation(launcher.getAbsolutePath(), this.computeLibraryPath(launcher));
    }

    public String computeLibraryPath(File launcherPath) {
        if (WindowsUtils.thisIsWindows()) {
            return null;
        }
        String libraryPathEnvironmentVariable = SystemUtils.libraryPathEnvironmentVariable();
        String currentLibraryPath = WindowsUtils.loadEnvironment().getProperty(libraryPathEnvironmentVariable);
        return currentLibraryPath + File.pathSeparator + launcherPath.getParent();
    }
}

