/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.SeleniumServer;

public class RemoteControlConfiguration {
    public static final int DEFAULT_PORT = 4444;
    private static final int USE_SAME_PORT = -1;
    public static final int MINUTES = 60;
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 1800;
    public static final int DEFAULT_RETRY_TIMEOUT_IN_SECONDS = 10;
    private int port;
    private File profilesLocation = null;
    private boolean proxyInjectionModeArg = false;
    private int portDriversShouldContact = -1;
    private boolean htmlSuite;
    private boolean selfTest;
    private File selfTestDir;
    private boolean interactive;
    private File userExtensions;
    private boolean userJSInjection;
    private boolean trustAllSSLCertificates;
    private String debugURL = "";
    private String dontInjectRegex = null;
    private File firefoxProfileTemplate = null;
    private boolean reuseBrowserSessions;
    private String logOutFileName;
    private String forcedBrowserMode;
    private boolean honorSystemProxy;
    private int timeoutInSeconds = 1800;
    private int retryTimeoutInSeconds = 10;
    private boolean dontTouchLogging = false;
    private boolean ensureCleanSession;
    private boolean avoidProxy;
    private boolean debugMode;
    private boolean browserSideLogEnabled;
    private int jettyThreads = SeleniumServer.DEFAULT_JETTY_THREADS;
    private SeleniumServer server;
    private boolean singleWindow;

    public RemoteControlConfiguration() {
        this.port = RemoteControlConfiguration.getDefaultPort();
        this.logOutFileName = RemoteControlConfiguration.getDefaultLogOutFile();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPortNumber) {
        this.port = newPortNumber;
    }

    public boolean isSingleWindow() {
        return this.singleWindow;
    }

    public void setSingleWindow(boolean useSingleWindow) {
        this.singleWindow = useSingleWindow;
    }

    public File getProfilesLocation() {
        return this.profilesLocation;
    }

    public void setProfilesLocation(File profilesLocation) {
        this.profilesLocation = profilesLocation;
    }

    public void setProxyInjectionModeArg(boolean proxyInjectionModeArg) {
        this.proxyInjectionModeArg = proxyInjectionModeArg;
    }

    public boolean getProxyInjectionModeArg() {
        return this.proxyInjectionModeArg;
    }

    public void setPortDriversShouldContact(int newPortDriversShouldContact) {
        this.portDriversShouldContact = newPortDriversShouldContact;
    }

    public int getPortDriversShouldContact() {
        if (-1 == this.portDriversShouldContact) {
            return this.port;
        }
        return this.portDriversShouldContact;
    }

    public void setHTMLSuite(boolean isHTMLSuite) {
        this.htmlSuite = isHTMLSuite;
    }

    public boolean isHTMLSuite() {
        return this.htmlSuite;
    }

    public boolean isSelfTest() {
        return this.selfTest;
    }

    public void setSelfTest(boolean isSelftest) {
        this.selfTest = isSelftest;
    }

    public void setSelfTestDir(File newSelfTestDir) {
        this.selfTestDir = newSelfTestDir;
    }

    public File getSelfTestDir() {
        return this.selfTestDir;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean isInteractive) {
        this.interactive = isInteractive;
    }

    public File getUserExtensions() {
        return this.userExtensions;
    }

    public void setUserExtensions(File newuserExtensions) {
        this.userExtensions = newuserExtensions;
    }

    public boolean userJSInjection() {
        return this.userJSInjection;
    }

    public void setUserJSInjection(boolean useUserJSInjection) {
        this.userJSInjection = useUserJSInjection;
    }

    public void setTrustAllSSLCertificates(boolean trustAllSSLCertificates) {
        this.trustAllSSLCertificates = trustAllSSLCertificates;
    }

    public boolean trustAllSSLCertificates() {
        return this.trustAllSSLCertificates;
    }

    public String getDebugURL() {
        return this.debugURL;
    }

    public void setDebugURL(String newDebugURL) {
        this.debugURL = newDebugURL;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDontInjectRegex(String newdontInjectRegex) {
        this.dontInjectRegex = newdontInjectRegex;
    }

    public String getDontInjectRegex() {
        return this.dontInjectRegex;
    }

    public File getFirefoxProfileTemplate() {
        return this.firefoxProfileTemplate;
    }

    public void setFirefoxProfileTemplate(File newFirefoxProfileTemplate) {
        this.firefoxProfileTemplate = newFirefoxProfileTemplate;
    }

    public void setReuseBrowserSessions(boolean reuseBrowserSessions) {
        this.reuseBrowserSessions = reuseBrowserSessions;
    }

    public boolean reuseBrowserSessions() {
        return this.reuseBrowserSessions;
    }

    public void setLogOutFileName(String newLogOutFileName) {
        this.logOutFileName = newLogOutFileName;
    }

    public String getLogOutFileName() {
        return this.logOutFileName;
    }

    public void setLogOutFile(File newLogOutFile) {
        this.logOutFileName = null == newLogOutFile ? null : newLogOutFile.getAbsolutePath();
    }

    public File getLogOutFile() {
        return null == this.logOutFileName ? null : new File(this.logOutFileName);
    }

    public static String getDefaultLogOutFile() {
        String logOutFileProperty = System.getProperty("selenium.LOGGER");
        if (null == logOutFileProperty) {
            return null;
        }
        return new File(logOutFileProperty).getAbsolutePath();
    }

    public void setForcedBrowserMode(String newForcedBrowserMode) {
        this.forcedBrowserMode = newForcedBrowserMode;
    }

    public String getForcedBrowserMode() {
        return this.forcedBrowserMode;
    }

    public static int getDefaultPort() {
        String portProperty = System.getProperty("selenium.port", "4444");
        if (null == portProperty) {
            return 4444;
        }
        return Integer.parseInt(portProperty);
    }

    public boolean honorSystemProxy() {
        return this.honorSystemProxy;
    }

    public void setHonorSystemProxy(boolean willHonorSystemProxy) {
        this.honorSystemProxy = willHonorSystemProxy;
    }

    public boolean shouldOverrideSystemProxy() {
        return !this.honorSystemProxy;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(int newTimeoutInSeconds) {
        this.timeoutInSeconds = newTimeoutInSeconds;
    }

    public int getRetryTimeoutInSeconds() {
        return this.retryTimeoutInSeconds;
    }

    public void setRetryTimeoutInSeconds(int newRetryTimeoutInSeconds) {
        this.retryTimeoutInSeconds = newRetryTimeoutInSeconds;
    }

    public boolean dontTouchLogging() {
        return this.dontTouchLogging;
    }

    public void setDontTouchLogging(boolean newValue) {
        this.dontTouchLogging = newValue;
    }

    public int shortTermMemoryLoggerCapacity() {
        return 30;
    }

    public boolean isEnsureCleanSession() {
        return this.ensureCleanSession;
    }

    public void setEnsureCleanSession(boolean value) {
        this.ensureCleanSession = value;
    }

    public boolean isAvoidProxy() {
        return this.avoidProxy;
    }

    public void setAvoidProxy(boolean value) {
        this.avoidProxy = value;
    }

    public boolean isBrowserSideLogEnabled() {
        return this.browserSideLogEnabled;
    }

    public void setBrowserSideLogEnabled(boolean value) {
        this.browserSideLogEnabled = value;
    }

    public int getJettyThreads() {
        return this.jettyThreads;
    }

    public void setJettyThreads(int jettyThreads) {
        int MAX_JETTY_THREADS = 1024;
        if (jettyThreads < 1 || jettyThreads > 1024) {
            throw new IllegalArgumentException("Number of jetty threads specified as an argument must be greater than zero and less than 1024");
        }
        this.jettyThreads = jettyThreads;
    }

    public SeleniumServer getSeleniumServer() {
        return this.server;
    }

    public void setSeleniumServer(SeleniumServer server) {
        this.server = server;
    }

    public void copySettingsIntoBrowserOptions(BrowserConfigurationOptions browserOptions) {
        browserOptions.setSafely("timeoutInSeconds", this.timeoutInSeconds);
        browserOptions.setSafely("honorSystemProxy", this.honorSystemProxy);
        browserOptions.setSafely("firefoxProfileTemplate", this.firefoxProfileTemplate);
        browserOptions.setSafely("dontInjectRegex", this.dontInjectRegex);
        browserOptions.setSafely("trustAllSSLCertificates", this.trustAllSSLCertificates);
        browserOptions.setSafely("userJSInjection", this.userJSInjection);
        browserOptions.setSafely("userExtensions", this.userExtensions);
        browserOptions.setSafely("proxyInjectionMode", this.proxyInjectionModeArg);
        browserOptions.setSafely("singleWindow", this.singleWindow);
        browserOptions.setSafely("ensureCleanSession", this.ensureCleanSession);
        browserOptions.setSafely("avoidProxy", this.avoidProxy);
        browserOptions.setSafely("browserSideLog", this.browserSideLogEnabled);
    }
}

