/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.openqa.jetty.html.Element;
import org.openqa.jetty.html.Page;

public class Composite
extends Element {
    protected ArrayList elements = new ArrayList(8);
    protected Composite nest = null;

    public Composite() {
    }

    public Composite(String attributes) {
        super(attributes);
    }

    public Composite add(Object o) {
        if (this.nest != null) {
            this.nest.add(o);
        } else if (o != null) {
            if (o instanceof Element) {
                if (o instanceof Page) {
                    throw new IllegalArgumentException("Can't insert Page in Composite");
                }
                this.elements.add(o);
            } else if (o instanceof String) {
                this.elements.add(o);
            } else {
                this.elements.add(o.toString());
            }
        }
        return this;
    }

    public Composite nest(Composite c) {
        if (this.nest != null) {
            return this.nest.nest(c);
        }
        this.add(c);
        this.nest = c;
        return this;
    }

    public Composite setNest(Composite c) {
        if (this.nest != null) {
            this.nest.setNest(c);
        } else {
            this.nest = c;
        }
        return this;
    }

    public Composite unnest() {
        if (this.nest != null) {
            this.nest.unnest();
        }
        this.nest = null;
        return this;
    }

    public int size() {
        return this.elements.size();
    }

    public void write(Writer out) throws IOException {
        for (int i = 0; i < this.elements.size(); ++i) {
            Object element = this.elements.get(i);
            if (element instanceof Element) {
                ((Element)element).write(out);
                continue;
            }
            if (element == null) {
                out.write("null");
                continue;
            }
            out.write(element.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String contents() {
        StringBuffer buf;
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Object element = this.elements.get(i);
                if (element == null) {
                    buf.append("null");
                    continue;
                }
                buf.append(element.toString());
            }
        }
        return buf.toString();
    }

    public Composite reset() {
        this.elements.clear();
        return this.unnest();
    }

    void flush(Writer out) throws IOException {
        if (this.nest != null) {
            this.nest.flush(out);
        } else {
            this.write(out);
            this.elements.clear();
        }
    }

    void flush(OutputStream out) throws IOException {
        this.flush(new OutputStreamWriter(out));
    }

    void flush(OutputStream out, String encoding) throws IOException {
        this.flush(new OutputStreamWriter(out, encoding));
    }

    public boolean replace(Object oldObj, Object newObj) {
        if (this.nest != null) {
            return this.nest.replace(oldObj, newObj);
        }
        int sz = this.elements.size();
        for (int i = 0; i < sz; ++i) {
            if (this.elements.get(i) != oldObj) continue;
            this.elements.set(i, newObj);
            return true;
        }
        return false;
    }
}

