/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.grid.shared.CliUtils;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.jetty.http.HashUserRealm;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.SecurityConstraint;
import org.openqa.jetty.http.SocketListener;
import org.openqa.jetty.http.handler.SecurityHandler;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.jetty.util.MultiException;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.ClassPathResource;
import org.openqa.selenium.server.ClasspathResourceLocator;
import org.openqa.selenium.server.FsResourceLocator;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ProxyHandler;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.ResourceServlet;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SessionExtensionJsHandler;
import org.openqa.selenium.server.SslCertificateGenerator;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.Sleeper;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.SeleniumHTMLRunnerResultsHandler;
import org.openqa.selenium.server.htmlrunner.SingleTestSuiteResourceHandler;

public class SeleniumServer
implements SslCertificateGenerator,
GridNodeServer {
    private Log LOGGER;
    private Server server;
    private BrowserLauncherFactory browserLauncherFactory;
    private SeleniumDriverResourceHandler driver;
    private SeleniumHTMLRunnerResultsHandler postResultsHandler;
    private StaticContentHandler staticContentHandler;
    private final RemoteControlConfiguration configuration;
    private Thread shutDownHook;
    private static final NetworkUtils networkUtils = new NetworkUtils();
    private ProxyHandler proxyHandler;
    public static int DEFAULT_JETTY_THREADS = 512;
    private int jettyThreads = DEFAULT_JETTY_THREADS;
    private boolean debugMode = false;
    private final Object shutdownLock = new Object();
    private static final int MAX_SHUTDOWN_RETRIES = 8;

    public static void main(String[] args) throws Exception {
        RemoteControlConfiguration configuration = SeleniumServer.parseLauncherOptions(args);
        SeleniumServer.checkArgsSanity(configuration);
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        SeleniumServer seleniumProxy = new SeleniumServer(SeleniumServer.slowResourceProperty(), configuration);
        seleniumProxy.boot();
        seleniumProxy.LOGGER.info(String.format("RemoteWebDriver instances should connect to: http://%s:%d/wd/hub", networkUtils.getPrivateLocalAddress(), seleniumProxy.getPort()));
    }

    public SeleniumServer() throws Exception {
        this(SeleniumServer.slowResourceProperty(), new RemoteControlConfiguration());
    }

    public SeleniumServer(Map<String, Object> configurationAsMap) throws Exception {
        this(SeleniumServer.slowResourceProperty(), SeleniumServer.mapToRemoteControlConfiguration(configurationAsMap));
        String servletsStr = (String)configurationAsMap.get("servlets");
        if (servletsStr != null) {
            this.registerExtraServlets(Arrays.asList(servletsStr.split(",")));
        }
    }

    private static RemoteControlConfiguration mapToRemoteControlConfiguration(Map<String, Object> configurationAsMap) {
        ArrayList<String> params = new ArrayList<String>();
        for (String key : configurationAsMap.keySet()) {
            params.add("-" + key);
            if (configurationAsMap.get(key).toString().trim().isEmpty()) continue;
            params.add("" + configurationAsMap.get(key));
        }
        return SeleniumServer.parseLauncherOptions(params.toArray(new String[params.size()]));
    }

    public SeleniumServer(RemoteControlConfiguration configuration) throws Exception {
        this(SeleniumServer.slowResourceProperty(), configuration);
    }

    public SeleniumServer(boolean slowResources) throws Exception {
        this(slowResources, new RemoteControlConfiguration());
    }

    public SeleniumServer(boolean slowResources, RemoteControlConfiguration configuration) throws Exception {
        this.configuration = configuration;
        this.debugMode = configuration.isDebugMode();
        this.jettyThreads = configuration.getJettyThreads();
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        this.LOGGER = SeleniumServer.configureLogging(configuration.getLoggingOptions(), this.debugMode);
        this.logStartupInfo();
        this.sanitizeProxyConfiguration();
        this.createJettyServer(slowResources);
        configuration.setSeleniumServer(this);
    }

    public static synchronized Log configureLogging(LoggingOptions options, boolean debugMode) {
        if (options.dontTouchLogging()) {
            return LogFactory.getLog("org.openqa.selenium.server.SeleniumServer");
        }
        LoggingManager.configureLogging(options, debugMode);
        Log seleniumServerJettyLogger = LogFactory.getLog("org.openqa.selenium.server.SeleniumServer");
        if (options.getLogOutFile() != null) {
            seleniumServerJettyLogger.info("Writing debug logs to " + options.getLogOutFile());
        }
        return seleniumServerJettyLogger;
    }

    @Override
    public void boot() throws Exception {
        this.start();
        if (this.configuration.getUserExtensions() != null) {
            this.addNewStaticContent(this.configuration.getUserExtensions().getParentFile());
        }
        if (this.configuration.isHTMLSuite()) {
            this.runHtmlSuite();
            return;
        }
        if (this.configuration.isInteractive()) {
            this.readUserCommands();
        }
    }

    protected void createJettyServer(boolean slowResources) {
        this.server = new Server();
        SocketListener socketListener = new SocketListener();
        socketListener.setMaxIdleTimeMs(60000);
        socketListener.setMaxThreads(this.jettyThreads);
        socketListener.setPort(this.getPort());
        this.server.addListener(socketListener);
        this.assembleHandlers(slowResources, this.configuration);
    }

    private void logVersionNumber() throws IOException {
        Properties p = new Properties();
        InputStream stream = ClassPathResource.getSeleniumResourceAsStream("/VERSION.txt");
        if (stream == null) {
            this.LOGGER.error("Couldn't determine version number");
            return;
        }
        p.load(stream);
        String rcVersion = p.getProperty("selenium.rc.version");
        String rcRevision = p.getProperty("selenium.rc.revision");
        String coreVersion = p.getProperty("selenium.core.version");
        String coreRevision = p.getProperty("selenium.core.revision");
        BuildInfo info = new BuildInfo();
        this.LOGGER.info(String.format("v%s%s, with Core v%s%s. Built from revision %s", rcVersion, rcRevision, coreVersion, coreRevision, info.getBuildRevision()));
    }

    private void assembleHandlers(boolean slowResources, RemoteControlConfiguration configuration) {
        this.server.addContext(this.createRootContextWithProxyHandler(configuration));
        HttpContext context = new HttpContext();
        context.setContextPath("/selenium-server");
        context.setMimeMapping("xhtml", "application/xhtml+xml");
        this.addSecurityHandler(context);
        this.addStaticContentHandler(slowResources, configuration, context);
        context.addHandler(new SessionExtensionJsHandler());
        context.addHandler(new SingleTestSuiteResourceHandler());
        this.postResultsHandler = new SeleniumHTMLRunnerResultsHandler();
        context.addHandler(this.postResultsHandler);
        this.server.addContext(context);
        DefaultDriverSessions webdriverSessions = new DefaultDriverSessions();
        this.server.addContext(this.createDriverContextWithSeleniumDriverResourceHandler(context, webdriverSessions));
        this.server.addContext(this.createWebDriverRemoteContext(webdriverSessions));
    }

    private HttpContext createDriverContextWithSeleniumDriverResourceHandler(HttpContext context, DriverSessions webdriverSessions) {
        HttpContext driverContext = new HttpContext();
        driverContext.setContextPath("/selenium-server/driver");
        this.browserLauncherFactory = new BrowserLauncherFactory(webdriverSessions);
        this.driver = new SeleniumDriverResourceHandler(this, this.browserLauncherFactory);
        context.addHandler(this.driver);
        return driverContext;
    }

    private HttpContext createWebDriverRemoteContext(DriverSessions webDriverSessions) {
        long browserTimeout;
        HttpContext webdriverContext = new HttpContext();
        long sessionTimeout = this.configuration.getTimeoutInSeconds();
        if (sessionTimeout == 0L) {
            sessionTimeout = -1L;
        }
        browserTimeout = (browserTimeout = (long)this.configuration.getBrowserTimeoutInMs()) == 0L ? -1L : (browserTimeout /= 1000L);
        webdriverContext.setInitParameter("webdriver.server.session.timeout", String.valueOf(sessionTimeout));
        webdriverContext.setInitParameter("webdriver.server.browser.timeout", String.valueOf(browserTimeout));
        webdriverContext.setAttribute(DriverServlet.SESSIONS_KEY, webDriverSessions);
        webdriverContext.setContextPath("/wd");
        ServletHandler handler = new ServletHandler();
        handler.addServlet("WebDriver remote server", "/hub/*", DriverServlet.class.getName());
        webdriverContext.addHandler(handler);
        return webdriverContext;
    }

    private void addStaticContentHandler(boolean slowResources, RemoteControlConfiguration configuration, HttpContext context) {
        StaticContentHandler.setSlowResources(slowResources);
        this.staticContentHandler = new StaticContentHandler(configuration.getDebugURL(), configuration.getProxyInjectionModeArg());
        String overrideJavascriptDir = System.getProperty("selenium.javascript.dir");
        if (overrideJavascriptDir != null) {
            this.staticContentHandler.addStaticContent(new FsResourceLocator(new File(overrideJavascriptDir)));
        }
        this.staticContentHandler.addStaticContent(new ClasspathResourceLocator());
        context.addHandler(this.staticContentHandler);
    }

    private void addSecurityHandler(HttpContext context) {
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setName("BASIC");
        constraint.addRole("user");
        constraint.setAuthenticate(true);
        context.addSecurityConstraint("/org/openqa/selenium/tests/html/basicAuth/*", constraint);
        HashUserRealm realm = new HashUserRealm("MyRealm");
        realm.put("alice", "foo");
        realm.addUserToRole("alice", "user");
        context.setRealm(realm);
        SecurityHandler sh = new SecurityHandler();
        context.addHandler(sh);
    }

    protected HttpContext createRootContextWithProxyHandler(RemoteControlConfiguration configuration) {
        HttpContext root = new HttpContext();
        root.setContextPath("/");
        this.proxyHandler = this.makeProxyHandler(configuration);
        root.addHandler(this.proxyHandler);
        return root;
    }

    @Override
    public void generateSSLCertsForLoggingHosts() {
        this.proxyHandler.generateSSLCertsForLoggingHosts(this.server);
    }

    protected ProxyHandler makeProxyHandler(RemoteControlConfiguration configuration) {
        return new ProxyHandler(configuration.trustAllSSLCertificates(), configuration.getDontInjectRegex(), configuration.getDebugURL(), configuration.getProxyInjectionModeArg(), false, configuration.getPort(), this.shutdownLock);
    }

    private static boolean slowResourceProperty() {
        return "true".equals(System.getProperty("slowResources"));
    }

    public void addNewStaticContent(File directory) {
        this.staticContentHandler.addStaticContent(new FsResourceLocator(directory));
    }

    public void handleHTMLRunnerResults(HTMLResultsListener listener) {
        this.postResultsHandler.addListener(listener);
    }

    public void start() throws Exception {
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        try {
            this.server.start();
        }
        catch (MultiException e) {
            if (e.getExceptions().size() == 1 && e.getException(0) instanceof BindException) {
                throw new BindException("Selenium is already running on port " + this.getPort() + ". Or some other service is.");
            }
            throw e;
        }
        this.shutDownHook = new Thread(new ShutDownHook(this));
        this.shutDownHook.setName("SeleniumServerShutDownHook");
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int numTries = 0;
        Exception shutDownException = null;
        try {
            if (this.shutDownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        while (numTries <= 8) {
            ++numTries;
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    this.server.stop();
                    break;
                }
            }
            catch (Exception ex) {
                this.LOGGER.error(ex);
                shutDownException = ex;
            }
        }
        this.driver.stopAllBrowsers();
        if (numTries > 8 && shutDownException != null) {
            throw new RuntimeException(shutDownException);
        }
    }

    public RemoteControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public BrowserLauncherFactory getBrowserLauncherFactory() {
        return this.browserLauncherFactory;
    }

    public int getPort() {
        return this.configuration.getPort();
    }

    @Override
    public int getRealPort() {
        if (this.server.isStarted()) {
            SocketListener socket = (SocketListener)this.server.getListeners()[0];
            return socket.getPort();
        }
        return this.getPort();
    }

    @Deprecated
    public Server getServer() {
        return this.server;
    }

    public void registerExtraServlets(List<String> servlets) {
        HttpContext extra = new HttpContext();
        extra.setContextPath("/extra");
        ServletHandler handler = new ServletHandler();
        handler.addServlet("/resources/*", ResourceServlet.class.getName());
        for (String s : servlets) {
            Class<? extends Servlet> servletClass = this.createServlet(s);
            if (servletClass == null) continue;
            String path = "/" + servletClass.getSimpleName() + "/*";
            String clazz = servletClass.getCanonicalName();
            handler.addServlet(path, clazz);
            this.LOGGER.info("started extra node servlet visible at : http://xxx:" + this.configuration.getPort() + "/extra" + path);
        }
        extra.addHandler(handler);
        this.server.addContext(extra);
    }

    private Class<? extends Servlet> createServlet(String className) {
        try {
            return Class.forName(className).asSubclass(Servlet.class);
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.error("The specified class : " + className + " cannot be instantiated " + e.getMessage());
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return this.staticContentHandler.getResource(path).getInputStream();
    }

    public void registerBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.driver.registerBrowserSession(sessionInfo);
    }

    public void deregisterBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.driver.deregisterBrowserSession(sessionInfo);
    }

    public int getJettyThreads() {
        return this.jettyThreads;
    }

    protected void runHtmlSuite() {
        try {
            String result;
            String fileName;
            String suiteFilePath = this.getRequiredSystemProperty("htmlSuite.suiteFilePath");
            File suiteFile = new File(suiteFilePath).getCanonicalFile();
            if (!suiteFile.exists()) {
                SeleniumServer.usage("Can't find HTML Suite file:" + suiteFile);
                System.exit(1);
            }
            if (!((fileName = suiteFile.getName()).endsWith(".html") || fileName.endsWith(".htm") || fileName.endsWith(".xhtml"))) {
                SeleniumServer.usage("Suite file must have extension .html or .htm or .xhtml");
                System.exit(1);
            }
            this.addNewStaticContent(suiteFile.getParentFile());
            String startURL = this.getRequiredSystemProperty("htmlSuite.startURL");
            HTMLLauncher launcher = new HTMLLauncher(this);
            String resultFilePath = this.getRequiredSystemProperty("htmlSuite.resultFilePath");
            File resultFile = new File(resultFilePath);
            File resultDir = resultFile.getParentFile();
            if (resultDir != null && !resultDir.exists() && !resultDir.mkdirs()) {
                SeleniumServer.usage("can't create directory for result file " + resultFilePath);
                System.exit(1);
            }
            resultFile.createNewFile();
            if (!resultFile.canWrite()) {
                SeleniumServer.usage("can't write to result file " + resultFilePath);
                System.exit(1);
            }
            if (!"PASSED".equals(result = launcher.runHTMLSuite(this.getRequiredSystemProperty("htmlSuite.browserString"), startURL, suiteFile, resultFile, this.configuration.getTimeoutInSeconds(), !this.configuration.isSingleWindow()))) {
                System.err.println("Tests failed, see result file for details: " + resultFile.getAbsolutePath());
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("HTML suite exception seen:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void readUserCommands() throws IOException {
        String userInput;
        Sleeper.sleepTight(500L);
        System.out.println("Entering interactive mode... type Selenium commands here (e.g: cmd=open&1=http://www.yahoo.com)");
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        final String[] lastSessionId = new String[]{""};
        while ((userInput = stdIn.readLine()) != null) {
            if ("exit".equals(userInput = userInput.trim()) || "quit".equals(userInput)) {
                System.out.println("Stopping...");
                this.stop();
                System.exit(0);
            }
            if ("".equals(userInput)) continue;
            if (!userInput.startsWith("cmd=") && !userInput.startsWith("commandResult=")) {
                System.err.println("ERROR -  Invalid command: \"" + userInput + "\"");
                continue;
            }
            final boolean newBrowserSession = userInput.contains("getNewBrowserSession");
            if (!userInput.contains("sessionId") && !newBrowserSession) {
                userInput = String.valueOf(userInput) + "&sessionId=" + lastSessionId[0];
            }
            final URL url = new URL("http://localhost:" + this.configuration.getPort() + "/selenium-server/driver?" + userInput);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block16: {
                        InputStream is = null;
                        try {
                            try {
                                int length;
                                SeleniumServer.this.LOGGER.info("---> Requesting " + url.toString());
                                URLConnection conn = url.openConnection();
                                conn.connect();
                                is = conn.getInputStream();
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                byte[] buffer = new byte[2048];
                                while ((length = is.read(buffer)) != -1) {
                                    out.write(buffer, 0, length);
                                }
                                is.close();
                                String output = out.toString();
                                if (newBrowserSession && output.startsWith("OK,")) {
                                    lastSessionId[0] = output.substring(3);
                                }
                            }
                            catch (IOException e) {
                                System.err.println(e.getMessage());
                                if (SeleniumServer.this.debugMode) {
                                    e.printStackTrace();
                                }
                                if (is == null) break block16;
                                try {
                                    is.close();
                                }
                                catch (IOException e2) {
                                    System.err.println(e2.getMessage());
                                    if (SeleniumServer.this.debugMode) {
                                        e2.printStackTrace();
                                    }
                                }
                            }
                        }
                        finally {
                            block17: {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e) {
                                        System.err.println(e.getMessage());
                                        if (!SeleniumServer.this.debugMode) break block17;
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    protected static void checkArgsSanity(RemoteControlConfiguration configuration) throws Exception {
        if (configuration.isInteractive()) {
            if (configuration.isHTMLSuite()) {
                System.err.println("You can't use -interactive and -htmlSuite on the same line!");
                System.exit(1);
            }
            if (configuration.isSelfTest()) {
                System.err.println("You can't use -interactive and -selfTest on the same line!");
                System.exit(1);
            }
        } else if (configuration.isSelfTest() && configuration.isHTMLSuite()) {
            System.err.println("You can't use -selfTest and -htmlSuite on the same line!");
            System.exit(1);
        }
        if (!configuration.getProxyInjectionModeArg() && (InjectionHelper.userContentTransformationsExist() || InjectionHelper.userJsInjectionsExist())) {
            SeleniumServer.usage("-userJsInjection and -userContentTransformation are only valid in combination with -proxyInjectionMode");
            System.exit(1);
        }
    }

    private void sanitizeProxyConfiguration() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (Integer.toString(this.getPort()).equals(proxyPort)) {
            this.LOGGER.debug("http.proxyPort is the same as the Selenium Server port " + this.getPort());
            this.LOGGER.debug("http.proxyHost=" + proxyHost);
            if ("localhost".equals(proxyHost) || "127.0.0.1".equals(proxyHost)) {
                this.LOGGER.info("Forcing http.proxyHost to '' to avoid infinite loop");
                System.setProperty("http.proxyHost", "");
            }
        }
    }

    private void logStartupInfo() throws IOException {
        this.LOGGER.info("Java: " + System.getProperty("java.vm.vendor") + ' ' + System.getProperty("java.vm.version"));
        this.LOGGER.info("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch"));
        this.logVersionNumber();
        if (this.debugMode) {
            this.LOGGER.info("Selenium server running in debug mode.");
        }
        if (this.configuration.getProxyInjectionModeArg()) {
            this.LOGGER.info("The selenium server will execute in proxyInjection mode.");
        }
        if (this.configuration.reuseBrowserSessions()) {
            this.LOGGER.info("Will recycle browser sessions when possible.");
        }
        if (this.configuration.getForcedBrowserMode() != null) {
            this.LOGGER.info("\"" + this.configuration.getForcedBrowserMode() + "\" will be used as the browser " + "mode for all sessions, no matter what is passed to getNewBrowserSession.");
        }
    }

    private String getRequiredSystemProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            SeleniumServer.usage("expected property " + name + " to be defined");
            System.exit(1);
        }
        return value;
    }

    public static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        String INDENT = "  ";
        String INDENT2X = String.valueOf(INDENT) + INDENT;
        CliUtils.printWrappedLine("", "Usage: java -jar selenium-server.jar [-interactive] [options]\n");
        CliUtils.printWrappedLine(INDENT, "-port <nnnn>: the port number the selenium server should use (default 4444)");
        CliUtils.printWrappedLine(INDENT, "-timeout <nnnn>: an integer number of seconds we should allow a client to be idle");
        CliUtils.printWrappedLine(INDENT, "-browserTimeout <nnnn>: an integer number of seconds a browser is allowed to hang");
        CliUtils.printWrappedLine(INDENT, "-interactive: puts you into interactive mode.  See the tutorial for more details");
        CliUtils.printWrappedLine(INDENT, "-singleWindow: puts you into a mode where the test web site executes in a frame. This mode should only be selected if the application under test does not use frames.");
        CliUtils.printWrappedLine(INDENT, "-profilesLocation: Specifies the directory that holds the profiles that java clients can use to start up selenium.  Currently supported for Firefox only.");
        CliUtils.printWrappedLine(INDENT, "-forcedBrowserMode <browser>: sets the browser mode to a single argument (e.g. \"*iexplore\") for all sessions, no matter what is passed to getNewBrowserSession");
        CliUtils.printWrappedLine(INDENT, "-forcedBrowserModeRestOfLine <browser>: sets the browser mode to all the remaining tokens on the line (e.g. \"*custom /some/random/place/iexplore.exe\") for all sessions, no matter what is passed to getNewBrowserSession");
        CliUtils.printWrappedLine(INDENT, "-userExtensions <file>: indicates a JavaScript file that will be loaded into selenium");
        CliUtils.printWrappedLine(INDENT, "-browserSessionReuse: stops re-initialization and spawning of the browser between tests");
        CliUtils.printWrappedLine(INDENT, "-avoidProxy: By default, we proxy every browser request; set this flag to make the browser use our proxy only for URLs containing '/selenium-server'");
        CliUtils.printWrappedLine(INDENT, "-firefoxProfileTemplate <dir>: normally, we generate a fresh empty Firefox profile every time we launch.  You can specify a directory to make us copy your profile directory instead.");
        CliUtils.printWrappedLine(INDENT, "-debug: puts you into debug mode, with more trace information and diagnostics on the console");
        CliUtils.printWrappedLine(INDENT, "-browserSideLog: enables logging on the browser side; logging messages will be transmitted to the server.  This can affect performance.");
        CliUtils.printWrappedLine(INDENT, "-ensureCleanSession: If the browser does not have user profiles, make sure every new session has no artifacts from previous sessions.  For example, enabling this option will cause all user cookies to be archived before launching IE, and restored after IE is closed.");
        CliUtils.printWrappedLine(INDENT, "-trustAllSSLCertificates: Forces the Selenium proxy to trust all SSL certificates.  This doesn't work in browsers that don't use the Selenium proxy.");
        CliUtils.printWrappedLine(INDENT, "-log <logFileName>: writes lots of debug information out to a log file and disables logging to console");
        CliUtils.printWrappedLine(INDENT, "-logLongForm: writes information out to console in long format (for debugging purpose)");
        CliUtils.printWrappedLine(INDENT, "-htmlSuite <browser> <startURL> <suiteFile> <resultFile>: Run a single HTML Selenese (Selenium Core) suite and then exit immediately, using the specified browser (e.g. \"*firefox\") on the specified URL (e.g. \"http://www.google.com\").  You need to specify the absolute path to the HTML test suite as well as the path to the HTML results file we'll generate.");
        CliUtils.printWrappedLine(INDENT, "-proxyInjectionMode: puts you into proxy injection mode, a mode where the selenium server acts as a proxy server for all content going to the test application.  Under this mode, multiple domains can be visited, and the following additional flags are supported:\n");
        CliUtils.printWrappedLine(INDENT2X, "-dontInjectRegex <regex>: an optional regular expression that proxy injection mode can use to know when to bypss injection");
        CliUtils.printWrappedLine(INDENT2X, "-userJsInjection <file>: specifies a JavaScript file which will then be injected into all pages");
        CliUtils.printWrappedLine(INDENT2X, "-userContentTransformation <regex> <replacement>: a regular expression which is matched against all test HTML content; the second is a string which will replace matches.  These flags can be used any number of times.  A simple example of how this could be useful: if you add \"-userContentTransformation https http\" then all \"https\" strings in the HTML of the test application will be changed to be \"http\".");
        CliUtils.printWrappedLine("", "\nThis synopsis lists options available in standalone role only. To get help on the options available for other roles run the server with -help option and the corresponding -role option value.");
    }

    public static RemoteControlConfiguration parseLauncherOptions(String[] args) {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setPort(RemoteControlConfiguration.getDefaultPort());
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-h".equalsIgnoreCase(arg) || "-help".equalsIgnoreCase(arg)) {
                SeleniumServer.usage(null);
                System.exit(1);
            } else if ("-defaultBrowserString".equalsIgnoreCase(arg)) {
                SeleniumServer.usage("-defaultBrowserString has been renamed -forcedBrowserMode");
            } else if ("-forcedBrowserMode".equalsIgnoreCase(arg)) {
                configuration.setForcedBrowserMode(SeleniumServer.getArg(args, ++i));
                if (i < args.length) {
                    System.err.println("Warning: -forcedBrowserMode no longer consumes all remaining arguments on line (use -forcedBrowserModeRestOfLine for that)");
                }
            } else if ("-forcedBrowserModeRestOfLine".equalsIgnoreCase(arg)) {
                ++i;
                while (i < args.length) {
                    if (configuration.getForcedBrowserMode() == null) {
                        configuration.setForcedBrowserMode("");
                    } else {
                        configuration.setForcedBrowserMode(String.valueOf(configuration.getForcedBrowserMode()) + " ");
                    }
                    configuration.setForcedBrowserMode(String.valueOf(configuration.getForcedBrowserMode()) + args[i]);
                    ++i;
                }
            } else if ("-log".equalsIgnoreCase(arg)) {
                configuration.setLogOutFileName(SeleniumServer.getArg(args, ++i));
            } else if ("-captureLogsOnQuit".equalsIgnoreCase(arg)) {
                configuration.setCaptureLogsOnQuit(true);
            } else if ("-port".equalsIgnoreCase(arg)) {
                configuration.setPort(Integer.parseInt(SeleniumServer.getArg(args, ++i)));
            } else if ("-multiWindow".equalsIgnoreCase(arg)) {
                configuration.setSingleWindow(false);
            } else if ("-singleWindow".equalsIgnoreCase(arg)) {
                configuration.setSingleWindow(true);
            } else if ("-profilesLocation".equalsIgnoreCase(arg)) {
                File profilesLocation;
                if (!(profilesLocation = new File(SeleniumServer.getArg(args, ++i))).exists()) {
                    System.err.println("Specified profile location directory does not exist: " + profilesLocation);
                    System.exit(1);
                }
                configuration.setProfilesLocation(profilesLocation);
            } else if ("-avoidProxy".equalsIgnoreCase(arg)) {
                configuration.setAvoidProxy(true);
            } else if ("-proxyInjectionMode".equalsIgnoreCase(arg)) {
                configuration.setProxyInjectionModeArg(true);
                configuration.setSingleWindow(true);
            } else if ("-portDriversShouldContact".equalsIgnoreCase(arg)) {
                configuration.setPortDriversShouldContact(Integer.parseInt(SeleniumServer.getArg(args, ++i)));
            } else if ("-noBrowserSessionReuse".equalsIgnoreCase(arg)) {
                configuration.setReuseBrowserSessions(false);
            } else if ("-browserSessionReuse".equalsIgnoreCase(arg)) {
                configuration.setReuseBrowserSessions(true);
            } else if ("-firefoxProfileTemplate".equalsIgnoreCase(arg)) {
                configuration.setFirefoxProfileTemplate(new File(SeleniumServer.getArg(args, ++i)));
                if (!configuration.getFirefoxProfileTemplate().exists()) {
                    System.err.println("Firefox profile template doesn't exist: " + configuration.getFirefoxProfileTemplate().getAbsolutePath());
                    System.exit(1);
                }
            } else if ("-ensureCleanSession".equalsIgnoreCase(arg)) {
                configuration.setEnsureCleanSession(true);
            } else if ("-dontInjectRegex".equalsIgnoreCase(arg)) {
                configuration.setDontInjectRegex(SeleniumServer.getArg(args, ++i));
            } else if ("-browserSideLog".equalsIgnoreCase(arg)) {
                configuration.setBrowserSideLogEnabled(true);
            } else if ("-debug".equalsIgnoreCase(arg)) {
                configuration.setDebugMode(true);
            } else if ("-debugURL".equalsIgnoreCase(arg)) {
                configuration.setDebugURL(SeleniumServer.getArg(args, ++i));
            } else if ("-timeout".equalsIgnoreCase(arg)) {
                configuration.setTimeoutInSeconds(Integer.parseInt(SeleniumServer.getArg(args, ++i)));
            } else if ("-jettyThreads".equalsIgnoreCase(arg)) {
                int jettyThreadsCount = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                configuration.setJettyThreads(jettyThreadsCount);
            } else if ("-trustAllSSLCertificates".equalsIgnoreCase(arg)) {
                configuration.setTrustAllSSLCertificates(true);
            } else if ("-userJsInjection".equalsIgnoreCase(arg)) {
                configuration.setUserJSInjection(true);
                if (!InjectionHelper.addUserJsInjectionFile(SeleniumServer.getArg(args, ++i))) {
                    SeleniumServer.usage(null);
                    System.exit(1);
                }
            } else if ("-userContentTransformation".equalsIgnoreCase(arg)) {
                if (!InjectionHelper.addUserContentTransformation(SeleniumServer.getArg(args, ++i), SeleniumServer.getArg(args, ++i))) {
                    SeleniumServer.usage(null);
                    System.exit(1);
                }
            } else if ("-userExtensions".equalsIgnoreCase(arg)) {
                configuration.setUserExtensions(new File(SeleniumServer.getArg(args, ++i)));
                if (!configuration.getUserExtensions().exists()) {
                    System.err.println("User Extensions file doesn't exist: " + configuration.getUserExtensions().getAbsolutePath());
                    System.exit(1);
                }
                if (!"user-extensions.js".equalsIgnoreCase(configuration.getUserExtensions().getName())) {
                    System.err.println("User extensions file MUST be called \"user-extensions.js\": " + configuration.getUserExtensions().getAbsolutePath());
                    System.exit(1);
                }
            } else if ("-selfTest".equalsIgnoreCase(arg)) {
                configuration.setSelfTest(true);
                configuration.setSelfTestDir(new File(SeleniumServer.getArg(args, ++i)));
                configuration.getSelfTestDir().mkdirs();
            } else if ("-htmlSuite".equalsIgnoreCase(arg)) {
                try {
                    System.setProperty("htmlSuite.browserString", args[++i]);
                    System.setProperty("htmlSuite.startURL", args[++i]);
                    System.setProperty("htmlSuite.suiteFilePath", args[++i]);
                    System.setProperty("htmlSuite.resultFilePath", args[++i]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("Not enough command line arguments for -htmlSuite");
                    System.err.println("-htmlSuite requires you to specify:");
                    System.err.println("* browserString (e.g. \"*firefox\")");
                    System.err.println("* startURL (e.g. \"http://www.google.com\")");
                    System.err.println("* suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\")");
                    System.err.println("* resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\")");
                    System.exit(1);
                }
                configuration.setHTMLSuite(true);
            } else if ("-interactive".equalsIgnoreCase(arg)) {
                configuration.setTimeoutInSeconds(Integer.MAX_VALUE);
                configuration.setInteractive(true);
            } else if ("-honor-system-proxy".equals(arg)) {
                configuration.setHonorSystemProxy(true);
            } else if (arg.startsWith("-D")) {
                SeleniumServer.setSystemProperty(arg);
            }
            ++i;
        }
        if (configuration.userJSInjection() && !configuration.getProxyInjectionModeArg()) {
            System.err.println("User js injection can only be used w/ -proxyInjectionMode");
            System.exit(1);
        }
        if (configuration.getProfilesLocation() != null && configuration.getFirefoxProfileTemplate() != null) {
            System.err.println("Cannot specify both a profileDirectory and a firefoxProfileTemplate");
            System.exit(1);
        }
        if (configuration.getForcedBrowserMode() == null) {
            if (System.getProperty("selenium.defaultBrowserString") != null) {
                System.err.println("The selenium.defaultBrowserString property is no longer supported; use selenium.forcedBrowserMode instead.");
                System.exit(-1);
            }
            configuration.setForcedBrowserMode(System.getProperty("selenium.forcedBrowserMode"));
        }
        if (!configuration.getProxyInjectionModeArg() && System.getProperty("selenium.proxyInjectionMode") != null) {
            configuration.setProxyInjectionModeArg("true".equals(System.getProperty("selenium.proxyInjectionMode")));
        }
        if (!configuration.isBrowserSideLogEnabled() && System.getProperty("selenium.browserSideLog") != null) {
            configuration.setBrowserSideLogEnabled("true".equals(System.getProperty("selenium.browserSideLog")));
        }
        if (!configuration.isDebugMode() && System.getProperty("selenium.debugMode") != null) {
            configuration.setDebugMode("true".equals(System.getProperty("selenium.debugMode")));
        }
        return configuration;
    }

    private static String getArg(String[] args, int i) {
        if (i >= args.length) {
            SeleniumServer.usage("expected at least one more argument");
            System.exit(-1);
        }
        return args[i];
    }

    private static void setSystemProperty(String arg) {
        if (arg.indexOf(61) == -1) {
            SeleniumServer.usage("poorly formatted Java property setting (I expect to see '=') " + arg);
            System.exit(1);
        }
        String property = arg.replaceFirst("-D", "").replaceFirst("=.*", "");
        String value = arg.replaceFirst("[^=]*=", "");
        System.err.println("Setting system property " + property + " to " + value);
        System.setProperty(property, value);
    }

    private class ShutDownHook
    implements Runnable {
        private final SeleniumServer selenium;

        ShutDownHook(SeleniumServer selenium) {
            this.selenium = selenium;
        }

        @Override
        public void run() {
            SeleniumServer.this.LOGGER.info("Shutting down...");
            this.selenium.stop();
        }
    }
}

