/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpResponse;

public class JsonHttpResponseCodec
implements ResponseCodec<HttpResponse> {
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final BeanToJsonConverter beanToJsonConverter = new BeanToJsonConverter();
    private final JsonToBeanConverter jsonToBeanConverter = new JsonToBeanConverter();

    @Override
    public HttpResponse encode(Response response) {
        int status = response.getStatus() == 0 ? 200 : 500;
        byte[] data = this.beanToJsonConverter.convert(response).getBytes(Charsets.UTF_8);
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(status);
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        httpResponse.setHeader("Content-Length", String.valueOf(data.length));
        httpResponse.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        httpResponse.setContent(data);
        return httpResponse;
    }

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content;
        block13: {
            String contentType = Strings.nullToEmpty(encodedResponse.getHeader("Content-Type"));
            content = encodedResponse.getContentString().trim();
            try {
                return this.jsonToBeanConverter.convert(Response.class, content);
            }
            catch (JsonException e) {
                if (contentType.startsWith("application/json")) {
                    throw new IllegalArgumentException("Cannot decode response content: " + content, e);
                }
            }
            catch (ClassCastException e) {
                if (!contentType.startsWith("application/json")) break block13;
                if (content.isEmpty()) {
                    return new Response();
                }
                throw new IllegalArgumentException("Cannot decode response content: " + content, e);
            }
        }
        Response response = new Response();
        int statusCode = encodedResponse.getStatus();
        if (statusCode < 200 || statusCode > 299) {
            if (statusCode > 399 && statusCode < 500) {
                response.setStatus(9);
            } else {
                response.setStatus(13);
            }
        }
        if (encodedResponse.getContent().length > 0) {
            response.setValue(content);
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        if (response.getStatus() != null) {
            response.setState(ErrorCodes.toState(response.getStatus()));
        } else if (statusCode == 200) {
            response.setState(ErrorCodes.toState(0));
        }
        return response;
    }
}

