/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private ObjectSizeEstimator objectSizeEstimator;
    protected Timer timer;
    private volatile Timeout timeout;
    private long writeLimit;
    private long readLimit;
    protected long checkInterval = 1000L;
    final AtomicBoolean release = new AtomicBoolean(false);

    private void init(ObjectSizeEstimator newObjectSizeEstimator, Timer newTimer, long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.objectSizeEstimator = newObjectSizeEstimator;
        this.timer = newTimer;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    public AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
    }

    public AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, 1000L);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, 1000L);
    }

    public AbstractTrafficShapingHandler(Timer timer) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, 1000L);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        this.init(objectSizeEstimator, timer, 0L, 0L, 1000L);
    }

    public AbstractTrafficShapingHandler(Timer timer, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, checkInterval);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        this.init(objectSizeEstimator, timer, 0L, 0L, checkInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    private static long getTimeToWait(long limit, long bytes, long lastTime, long curtime) {
        long interval = curtime - lastTime;
        if (interval == 0L) {
            return 0L;
        }
        return (bytes * 1000L / limit - interval) / 10L * 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = this.objectSizeEstimator.estimateSize(arg1.getMessage());
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesRecvFlowControl(arg0, size);
                if (this.readLimit == 0L) {
                    return;
                }
                long wait = AbstractTrafficShapingHandler.getTimeToWait(this.readLimit, this.trafficCounter.getCurrentReadBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait >= 10L) {
                    Channel channel = arg0.getChannel();
                    if (channel != null && channel.isConnected()) {
                        if (this.timer == null) {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                            return;
                        }
                        if (arg0.getAttachment() == null) {
                            arg0.setAttachment(Boolean.TRUE);
                            channel.setReadable(false);
                            ReopenReadTimerTask timerTask = new ReopenReadTimerTask(arg0);
                            this.timeout = this.timer.newTimeout(timerTask, wait, TimeUnit.MILLISECONDS);
                        } else {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                        }
                    } else {
                        if (this.release.get()) {
                            return;
                        }
                        Thread.sleep(wait);
                    }
                }
            }
        }
        finally {
            super.messageReceived(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequested(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = this.objectSizeEstimator.estimateSize(arg1.getMessage());
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesWriteFlowControl(size);
                if (this.writeLimit == 0L) {
                    return;
                }
                long wait = AbstractTrafficShapingHandler.getTimeToWait(this.writeLimit, this.trafficCounter.getCurrentWrittenBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait >= 10L) {
                    if (this.release.get()) {
                        return;
                    }
                    Thread.sleep(wait);
                }
            }
        }
        finally {
            super.writeRequested(arg0, arg1);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        super.handleDownstream(ctx, e);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    private class ReopenReadTimerTask
    implements TimerTask {
        ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeoutArg) throws Exception {
            if (AbstractTrafficShapingHandler.this.release.get()) {
                return;
            }
            if (this.ctx != null && this.ctx.getChannel() != null && this.ctx.getChannel().isConnected()) {
                this.ctx.setAttachment(null);
                this.ctx.getChannel().setReadable(true);
            }
        }
    }
}

