/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.applet.Applet;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClasses(value={@JsxClass(domClass=HtmlApplet.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, domClass=HtmlApplet.class, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLAppletElement
extends HTMLElement {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLAppletElement() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode.getPage().getWebClient().getOptions().isAppletEnabled()) {
            try {
                this.createAppletMethodAndProperties();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAppletMethodAndProperties() throws Exception {
        HtmlApplet appletNode = (HtmlApplet)this.getDomNodeOrDie();
        final Applet applet = appletNode.getApplet();
        if (applet == null) {
            return;
        }
        for (final Method method : applet.getClass().getMethods()) {
            BaseFunction f = new BaseFunction(){

                @Override
                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    for (int i = 0; i < realArgs.length; ++i) {
                        Object arg = i > args.length ? null : Context.jsToJava(args[i], method.getParameterTypes()[i]);
                        realArgs[i] = arg;
                    }
                    try {
                        return method.invoke((Object)applet, realArgs);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx(e);
                    }
                }
            };
            ScriptableObject.defineProperty(this, method.getName(), f, 1);
        }
    }

    @JsxGetter
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if ((String.class.equals(hint) || hint == null) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_APPLET_OBJECT)) {
            return "[object]";
        }
        return super.getDefaultValue(hint);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFld() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFld(String dataFld) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFormatAs() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFormatAs(String dataFormatAs) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataSrc() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataSrc(String dataSrc) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getClassid() {
        String classid = this.getDomNodeOrDie().getAttribute("classid");
        return classid;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setClassid(String classid) {
        this.getDomNodeOrDie().setAttribute("classid", classid);
    }
}

