/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class IOHelper {
    private static final Logger log = Logger.getLogger(IOHelper.class.getName());
    private static final int DEFAULT_COPY_BUFFER_SIZE = 1024;

    public static void close(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            log.info("Ignoring exception while closing " + stream);
        }
    }

    public static byte[] readFile(String filePath) throws IOException {
        byte[] byArray;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOHelper.copyStream(inputStream, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOHelper.close(inputStream);
            throw throwable;
        }
        IOHelper.close(inputStream);
        return byArray;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        IOHelper.copyStream(in, out, 1024);
    }

    public static void copyStream(InputStream in, OutputStream out, int copyBufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[copyBufferSize];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }
}

