/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.GridDocHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.TerseFormatter;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class GridLauncher {
    private static final Logger log = Logger.getLogger(GridLauncher.class.getName());

    public static void main(String[] args) throws Exception {
        int n;
        String logFilename;
        Level logLevel;
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        if (helper.isParamPresent("-help") || helper.isParamPresent("-h")) {
            String separator = "\n----------------------------------\n";
            RemoteControlLauncher.usage(String.valueOf(separator) + "To use as a standalone server" + separator);
            GridDocHelper.printHelp(String.valueOf(separator) + "To use in a grid environment :" + separator, false);
            return;
        }
        Level level = logLevel = helper.isParamPresent("-debug") ? Level.FINE : LoggingOptions.getDefaultLogLevel();
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        Logger.getLogger("").setLevel(logLevel);
        String string = logFilename = helper.isParamPresent("-log") ? helper.getParamValue("-log") : LoggingOptions.getDefaultLogOutFile();
        if (logFilename != null) {
            Handler[] handlerArray = Logger.getLogger("").getHandlers();
            n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler instanceof ConsoleHandler) {
                    Logger.getLogger("").removeHandler(handler);
                }
                ++n2;
            }
            try {
                FileHandler logFile = new FileHandler(new File(logFilename).getAbsolutePath(), true);
                logFile.setFormatter(new TerseFormatter(true));
                logFile.setLevel(logLevel);
                Logger.getLogger("").addHandler(logFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            boolean logLongForm = helper.isParamPresent("-logLongForm");
            Handler[] handlerArray = Logger.getLogger("").getHandlers();
            int n3 = handlerArray.length;
            n = 0;
            while (n < n3) {
                Handler handler = handlerArray[n];
                if (handler instanceof ConsoleHandler) {
                    handler.setLevel(logLevel);
                    handler.setFormatter(new TerseFormatter(logLongForm));
                }
                ++n;
            }
        }
        GridRole role = GridRole.find(args);
        switch (role) {
            case NOT_GRID: {
                log.info("Launching a standalone server");
                SeleniumServer.main(args);
                break;
            }
            case HUB: {
                log.info("Launching a selenium grid server");
                try {
                    GridHubConfiguration c = GridHubConfiguration.build(args);
                    Hub h = new Hub(c);
                    h.start();
                }
                catch (GridConfigurationException e) {
                    GridDocHelper.printHelp(e.getMessage());
                    e.printStackTrace();
                }
                break;
            }
            case NODE: {
                log.info("Launching a selenium grid node");
                try {
                    RegistrationRequest c = RegistrationRequest.build(args);
                    SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
                    remote.startRemoteServer();
                    remote.startRegistrationProcess();
                }
                catch (GridConfigurationException e) {
                    GridDocHelper.printHelp(e.getMessage());
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }
}

