/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum WindowManagerMessage implements Message
{
    GET_ACTIVE_WINDOW(1),
    LIST_WINDOWS(2),
    MODIFY_FILTER(3),
    WINDOW_UPDATED(4),
    WINDOW_CLOSED(5),
    WINDOW_ACTIVATED(6),
    WINDOW_LOADED(7),
    CREATE_WINDOW(8),
    CLOSE_WINDOW(9),
    OPEN_URL(10),
    MODIFY_TYPE_FILTER(11),
    DEFAULT(-1);

    private static final Map<Integer, WindowManagerMessage> lookup;
    private final int code;

    private WindowManagerMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "window-manager";
    }

    public static WindowManagerMessage get(int code) {
        WindowManagerMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex(ImmutableList.copyOf(WindowManagerMessage.values()), new Function<WindowManagerMessage, Integer>(){

            @Override
            public Integer apply(WindowManagerMessage message) {
                return message.getID();
            }
        });
    }
}

