/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum EcmascriptMessage implements Message
{
    LIST_RUNTIMES(1),
    EVAL(2),
    EXAMINE_OBJECTS(3),
    RELEASE_OBJECTS(4),
    ON_READY_STATE_CHANGED(5),
    SET_FORM_ELEMENT_VALUE(6),
    DEFAULT(-1);

    private static final Map<Integer, EcmascriptMessage> lookup;
    private final int code;

    private EcmascriptMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    public static EcmascriptMessage get(int code) {
        EcmascriptMessage command = lookup.get(code);
        if (command == null) {
            return DEFAULT;
        }
        return command;
    }

    @Override
    public String getServiceName() {
        return "ecmascript";
    }

    static {
        lookup = Maps.uniqueIndex(ImmutableList.copyOf(EcmascriptMessage.values()), new Function<EcmascriptMessage, Integer>(){

            @Override
            public Integer apply(EcmascriptMessage command) {
                return command.getID();
            }
        });
    }
}

