/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitWrapFactory;
import com.gargoylesoftware.htmlunit.javascript.IEConditionalCompilationScriptPreProcessor;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorReporter;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.regexp.HtmlUnitRegExpProxy;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.ErrorReporter;
import net.sourceforge.htmlunit.corejs.javascript.Evaluator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.WrapFactory;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;

public class HtmlUnitContextFactory
extends ContextFactory {
    private static final int INSTRUCTION_COUNT_THRESHOLD = 10000;
    private final BrowserVersion browserVersion_;
    private final WebClient webClient_;
    private long timeout_;
    private Debugger debugger_;
    private final ErrorReporter errorReporter_;
    private final WrapFactory wrapFactory_ = new HtmlUnitWrapFactory();
    private boolean deminifyFunctionCode_ = false;

    public HtmlUnitContextFactory(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.browserVersion_ = webClient.getBrowserVersion();
        this.errorReporter_ = new StrictErrorReporter();
    }

    public void setTimeout(long timeout) {
        this.timeout_ = timeout;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger_ = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger_;
    }

    public void setDeminifyFunctionCode(boolean deminify) {
        this.deminifyFunctionCode_ = deminify;
    }

    public boolean isDeminifyFunctionCode() {
        return this.deminifyFunctionCode_;
    }

    protected String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        String newSourceCode = sourceCode;
        ScriptPreProcessor preProcessor = this.webClient_.getScriptPreProcessor();
        if (preProcessor != null && (newSourceCode = preProcessor.preProcess(htmlPage, sourceCode, sourceName, lineNumber, htmlElement)) == null) {
            newSourceCode = "";
        }
        return newSourceCode;
    }

    @Override
    protected Context makeContext() {
        TimeoutContext cx = new TimeoutContext(this);
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        this.configureErrorReporter(cx);
        cx.setWrapFactory(this.wrapFactory_);
        if (this.debugger_ != null) {
            cx.setDebugger(this.debugger_, null);
        }
        ScriptRuntime.setRegExpProxy(cx, new HtmlUnitRegExpProxy(ScriptRuntime.getRegExpProxy(cx), this.browserVersion_));
        cx.setMaximumInterpreterStackDepth(10000);
        return cx;
    }

    protected void configureErrorReporter(Context context) {
        context.setErrorReporter(this.errorReporter_);
    }

    @Override
    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.terminateScriptIfNecessary();
    }

    @Override
    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.startClock();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    @Override
    protected boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 3: {
                return true;
            }
            case 5: {
                return !this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_PARENT_PROTO_PROPERTIES);
            }
            case 1: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_NON_ECMA_GET_YEAR);
            }
            case 14: {
                return true;
            }
            case 15: {
                return false;
            }
            case 16: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ARGUMENTS_IS_OBJECT);
            }
            case 17: {
                return true;
            }
            case 18: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ARGUMENTS_READ_ONLY_ACCESSED_FROM_FUNCTION);
            }
            case 19: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_EVAL_LOCAL_SCOPE);
            }
            case 20: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK);
            }
            case 21: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR);
            }
            case 22: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_FUNCTION_OBJECT_METHOD);
            }
            case 23: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_FUNCTION_DECLARED_FORWARD_IN_BLOCK);
            }
            case 24: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_PARSE_INT_RADIX_10);
            }
            case 25: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ENUM_NUMBERS_FIRST);
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    private class TimeoutContext
    extends Context {
        private long startTime_;

        protected TimeoutContext(ContextFactory factory) {
            super(factory);
        }

        public void startClock() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void terminateScriptIfNecessary() {
            long currentTime;
            if (HtmlUnitContextFactory.this.timeout_ > 0L && (currentTime = System.currentTimeMillis()) - this.startTime_ > HtmlUnitContextFactory.this.timeout_) {
                throw new TimeoutError(HtmlUnitContextFactory.this.timeout_, currentTime - this.startTime_);
            }
        }

        @Override
        protected Script compileString(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            boolean isWindowEval;
            boolean bl = isWindowEval = compiler != null;
            if (!isWindowEval) {
                String sourceCodeTrimmed = source.trim();
                if (sourceCodeTrimmed.startsWith("<!--")) {
                    source = source.replaceFirst("<!--", "// <!--");
                }
                if (HtmlUnitContextFactory.this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_IGNORES_LAST_LINE_CONTAINING_UNCOMMENTED) && sourceCodeTrimmed.endsWith("-->")) {
                    int lastDoubleSlash = source.lastIndexOf("//");
                    int lastNewLine = Math.max(source.lastIndexOf(10), source.lastIndexOf(13));
                    if (lastNewLine > lastDoubleSlash) {
                        source = source.substring(0, lastNewLine);
                    }
                }
            }
            HtmlPage page = (HtmlPage)Context.getCurrentContext().getThreadLocal("startingPage");
            source = HtmlUnitContextFactory.this.preProcess(page, source, sourceName, lineno, null);
            if (HtmlUnitContextFactory.this.browserVersion_.hasFeature(BrowserVersionFeatures.HTMLCONDITIONAL_COMMENTS)) {
                IEConditionalCompilationScriptPreProcessor ieCCPreProcessor = new IEConditionalCompilationScriptPreProcessor();
                source = ieCCPreProcessor.preProcess(page, source, sourceName, lineno, null);
            }
            return super.compileString(source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }

        @Override
        protected Function compileFunction(Scriptable scope, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            if (HtmlUnitContextFactory.this.deminifyFunctionCode_) {
                Function f = super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                source = this.decompileFunction(f, 4).trim().replace("\n    ", "\n");
            }
            return super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }
    }
}

