/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.Map;
import org.apache.xml.utils.PrefixResolverDefault;
import org.w3c.dom.Node;

final class HtmlUnitPrefixResolver
extends PrefixResolverDefault {
    HtmlUnitPrefixResolver(Node xpathExpressionContext) {
        super(xpathExpressionContext);
    }

    @Override
    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        String namespace = super.getNamespaceForPrefix(prefix, namespaceContext);
        if (namespace == null) {
            if (namespaceContext instanceof XmlPage) {
                DomElement documentElement = ((XmlPage)namespaceContext).getDocumentElement();
                if (documentElement != null) {
                    namespace = this.getNamespace(documentElement, prefix);
                }
            } else if (namespaceContext instanceof DomElement) {
                namespace = this.getNamespace((DomElement)namespaceContext, prefix);
            }
        }
        return namespace;
    }

    private String getNamespace(DomElement element, String prefix) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        String xmlns = "xmlns:";
        int xmlnsLength = "xmlns:".length();
        for (String name : attributes.keySet()) {
            if (!name.startsWith("xmlns:") || !name.substring(xmlnsLength).equals(prefix)) continue;
            return attributes.get(name).getValue();
        }
        for (DomNode child : element.getChildren()) {
            String namespace;
            if (!(child instanceof DomElement) || (namespace = this.getNamespace((DomElement)child, prefix)) == null) continue;
            return namespace;
        }
        return null;
    }
}

