/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.html5.ResultSetRows;
import org.openqa.selenium.remote.server.KnownElements;

public class ResultConverter
implements Function<Object, Object> {
    private final KnownElements knownElements;

    public ResultConverter(KnownElements knownElements) {
        this.knownElements = knownElements;
    }

    @Override
    public Object apply(Object result) {
        if (result instanceof WebElement) {
            String elementId = this.knownElements.add((WebElement)result);
            return ImmutableMap.of("ELEMENT", elementId);
        }
        if (result instanceof List) {
            List resultAsList = (List)result;
            return Lists.newArrayList(Iterables.transform(resultAsList, this));
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            HashMap converted = Maps.newHashMapWithExpectedSize(resultAsMap.size());
            for (Map.Entry entry : resultAsMap.entrySet()) {
                converted.put(entry.getKey(), this.apply(entry.getValue()));
            }
            return converted;
        }
        if (result instanceof ResultSet) {
            HashMap<String, Serializable> converted = Maps.newHashMap();
            converted.put("insertId", Integer.valueOf(((ResultSet)result).getLastInsertedRowId()));
            converted.put("rowsAffected", Integer.valueOf(((ResultSet)result).getNumberOfRowsAffected()));
            ResultSetRows rsRows = ((ResultSet)result).rows();
            ArrayList<Map<String, Object>> rows = Lists.newArrayList();
            int i = 0;
            while (i < rsRows.size()) {
                rows.add(rsRows.item(i));
                ++i;
            }
            converted.put("rows", Lists.newArrayList(Iterables.transform(rows, this)));
            return converted;
        }
        return result;
    }
}

