/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class SetWindowPosition
extends WebDriverHandler
implements JsonParametersAware {
    private Point position;

    public SetWindowPosition(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        int y;
        int x;
        try {
            x = ((Number)allParameters.get("x")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) x window position value passed: " + allParameters.get("x"), ex);
        }
        try {
            y = ((Number)allParameters.get("y")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) y window position value passed: " + allParameters.get("y"), ex);
        }
        this.position = new Point(x, y);
    }

    @Override
    public ResultType call() throws Exception {
        this.getDriver().manage().window().setPosition(this.position);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return "[set window position]";
    }
}

