/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.net.URL;
import org.apache.http.client.methods.HttpUriRequest;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpVerb;
import org.openqa.selenium.remote.SessionId;

public class CommandInfo {
    private final String url;
    private final HttpVerb verb;

    public CommandInfo(String url, HttpVerb verb) {
        this.url = url;
        this.verb = verb;
    }

    HttpUriRequest getMethod(URL base, Command command) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(base.toExternalForm().replaceAll("/$", ""));
        String[] stringArray = this.url.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() != 0) {
                urlBuilder.append("/");
                if (part.startsWith(":")) {
                    String value = this.get(part.substring(1), command);
                    if (value != null) {
                        urlBuilder.append(this.get(part.substring(1), command));
                    }
                } else {
                    urlBuilder.append(part);
                }
            }
            ++n2;
        }
        return this.verb.createMethod(urlBuilder.toString());
    }

    private String get(String propertyName, Command command) {
        if ("sessionId".equals(propertyName)) {
            SessionId id = command.getSessionId();
            if (id == null) {
                throw new WebDriverException("Session ID may not be null");
            }
            return id.toString();
        }
        Object value = command.getParameters().get(propertyName);
        if (value != null) {
            return Urls.urlEncode(String.valueOf(value));
        }
        return null;
    }
}

