/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.NotificationResult;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import mx4j.tools.remote.http.HTTPConnection;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.SOAPHeaderElement;

public class SOAPClientInvoker
implements HTTPConnection {
    private static final QName qObjectName = new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "ObjectName");
    private static final QName qObjectInstance = new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "ObjectInstance");
    private static final QName qSubject = new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "Subject");
    private final String endpoint;
    private final Service service;
    private String connectionId;

    public SOAPClientInvoker(String endpoint, Service service) {
        this.endpoint = endpoint;
        this.service = service;
    }

    public String connect(Object credentials) throws IOException, SecurityException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "connect"));
        call.addParameter("credentials", XMLType.XSD_ANY, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        this.connectionId = (String)call.invoke(new Object[]{credentials});
        return this.connectionId;
    }

    public void close() throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "close"));
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[0]);
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    public Integer addNotificationListener(ObjectName name, Object filter, Subject delegate) throws InstanceNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "addNotificationListener"));
        call.addParameter("observed", qObjectName, ParameterMode.IN);
        call.addParameter("filter", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_INT);
        return (Integer)call.invoke(new Object[]{name, filter, delegate});
    }

    public void removeNotificationListeners(ObjectName observed, Integer[] ids, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "removeNotificationListeners"));
        call.addParameter("observed", qObjectName, ParameterMode.IN);
        call.addParameter("ids", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{observed, ids, delegate});
    }

    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "fetchNotifications"));
        call.addParameter("sequence", XMLType.XSD_LONG, ParameterMode.IN);
        call.addParameter("maxNumber", XMLType.XSD_INT, ParameterMode.IN);
        call.addParameter("timeout", XMLType.XSD_LONG, ParameterMode.IN);
        call.setReturnType(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "NotificationResult"));
        NotificationResult result = (NotificationResult)call.invoke(new Object[]{new Long(clientSequenceNumber), new Integer(maxNotifications), new Long(timeout)});
        return result;
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, Object filter, Object handback, Subject delegate) throws InstanceNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "addNotificationListener"));
        call.addParameter("observed", qObjectName, ParameterMode.IN);
        call.addParameter("listener", qObjectName, ParameterMode.IN);
        call.addParameter("filter", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("handback", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{name, listener, filter, handback, delegate});
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "removeNotificationListener"));
        call.addParameter("observed", qObjectName, ParameterMode.IN);
        call.addParameter("listener", qObjectName, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{name, listener, delegate});
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Object filter, Object handback, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "removeNotificationListener"));
        call.addParameter("observed", qObjectName, ParameterMode.IN);
        call.addParameter("listener", qObjectName, ParameterMode.IN);
        call.addParameter("filter", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("handback", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{name, listener, filter, handback, delegate});
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName, Subject delegate) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getMBeanInfo"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "MBeanInfo"));
        MBeanInfo info = (MBeanInfo)call.invoke(new Object[]{objectName, delegate});
        return info;
    }

    public boolean isInstanceOf(ObjectName objectName, String className, Subject delegate) throws InstanceNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "isInstanceOf"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("className", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_BOOLEAN);
        Boolean isinstanceof = (Boolean)call.invoke(new Object[]{objectName, className, delegate});
        return isinstanceof;
    }

    public String[] getDomains(Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getDomains"));
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.SOAP_ARRAY);
        String[] domains = (String[])call.invoke(new Object[]{delegate});
        return domains;
    }

    public String getDefaultDomain(Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getDefaultDomain"));
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        String domain = (String)call.invoke(new Object[]{delegate});
        return domain;
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object args, String[] parameters, Subject delegate) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "createMBean"));
        call.addParameter("className", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("arguments", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("signature", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(qObjectInstance);
        ObjectInstance instance = (ObjectInstance)call.invoke(new Object[]{className, objectName, args, parameters, delegate});
        return instance;
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object args, String[] parameters, Subject delegate) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "createMBean"));
        call.addParameter("className", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("loaderName", qObjectName, ParameterMode.IN);
        call.addParameter("arguments", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("signature", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(qObjectInstance);
        ObjectInstance instance = (ObjectInstance)call.invoke(new Object[]{className, objectName, loaderName, args, parameters, delegate});
        return instance;
    }

    public void unregisterMBean(ObjectName objectName, Subject delegate) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "unregisterMBean"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{objectName, delegate});
    }

    public Object getAttribute(ObjectName objectName, String attribute, Subject delegate) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getAttribute"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("attributeName", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_ANY);
        Object result = call.invoke(new Object[]{objectName, attribute, delegate});
        return result;
    }

    public void setAttribute(ObjectName objectName, Object attribute, Subject delegate) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "setAttribute"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("attribute", new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "Attribute"), ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{objectName, attribute, delegate});
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes, Subject delegate) throws InstanceNotFoundException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getAttributes"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("attributeNames", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "AttributeList"));
        AttributeList list = (AttributeList)call.invoke(new Object[]{objectName, attributes, delegate});
        return list;
    }

    public AttributeList setAttributes(ObjectName objectName, Object attributes, Subject delegate) throws InstanceNotFoundException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "setAttributes"));
        QName qAttributeList = new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "AttributeList");
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("attributeList", qAttributeList, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(qAttributeList);
        AttributeList list = (AttributeList)call.invoke(new Object[]{objectName, attributes, delegate});
        return list;
    }

    public Object invoke(ObjectName objectName, String methodName, Object args, String[] parameters, Subject delegate) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "invoke"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("operationName", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("arguments", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("signature", XMLType.SOAP_ARRAY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_ANY);
        Object object = call.invoke(new Object[]{objectName, methodName, args, parameters, delegate});
        return object;
    }

    public Integer getMBeanCount(Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getMBeanCount"));
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_INT);
        Integer count = (Integer)call.invoke(new Object[]{delegate});
        return count;
    }

    public boolean isRegistered(ObjectName objectName, Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "isRegistered"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_BOOLEAN);
        Boolean registered = (Boolean)call.invoke(new Object[]{objectName, delegate});
        return registered;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName, Subject delegate) throws InstanceNotFoundException, IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "getObjectInstance"));
        call.addParameter("objectName", qObjectName, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(qObjectInstance);
        ObjectInstance instance = (ObjectInstance)call.invoke(new Object[]{objectName, delegate});
        return instance;
    }

    public Set queryMBeans(ObjectName patternName, Object filter, Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "queryMBeans"));
        call.addParameter("pattern", qObjectName, ParameterMode.IN);
        call.addParameter("query", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "Set"));
        Set set = (Set)call.invoke(new Object[]{patternName, filter, delegate});
        return set;
    }

    public Set queryNames(ObjectName patternName, Object filter, Subject delegate) throws IOException {
        Call call = this.createCall();
        call.setOperationName(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "queryNames"));
        call.addParameter("pattern", qObjectName, ParameterMode.IN);
        call.addParameter("query", XMLType.XSD_ANY, ParameterMode.IN);
        call.addParameter("delegate", qSubject, ParameterMode.IN);
        call.setReturnType(new QName("http://mx4j.sourceforge.net/remote/soap/1.0", "Set"));
        Set set = (Set)call.invoke(new Object[]{patternName, filter, delegate});
        return set;
    }

    private Call createCall() throws IOException {
        try {
            Call call = (Call)this.service.createCall();
            call.setTargetEndpointAddress(this.endpoint);
            SOAPHeaderElement connectionIDHeader = new SOAPHeaderElement("http://mx4j.sourceforge.net/remote/soap/1.0", "connectionId", (Object)this.connectionId);
            connectionIDHeader.setMustUnderstand(true);
            call.addHeader(connectionIDHeader);
            return call;
        }
        catch (ServiceException x) {
            throw new IOException(x.toString());
        }
    }
}

