/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClasses={HtmlTableRow.class})
public class HTMLTableRowElement
extends HTMLTableComponent {
    private HTMLCollection cells_;

    @JsxGetter
    public int getRowIndex() {
        HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
        HtmlTable table = row.getEnclosingTable();
        if (table == null) {
            return -1;
        }
        return table.getRows().indexOf(row);
    }

    @JsxGetter
    public int getSectionRowIndex() {
        DomNode row = this.getDomNodeOrDie();
        HtmlTable table = ((HtmlTableRow)row).getEnclosingTable();
        if (table == null) {
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_108)) {
                return -1;
            }
            return 5461640;
        }
        int index = -1;
        while (row != null) {
            if (row instanceof HtmlTableRow) {
                ++index;
            }
            row = row.getPreviousSibling();
        }
        return index;
    }

    @JsxGetter
    public Object getCells() {
        if (this.cells_ == null) {
            final HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
            this.cells_ = new HTMLCollection(row, false, "cells"){

                @Override
                protected List<Object> computeElements() {
                    return new ArrayList<Object>(row.getCells());
                }
            };
        }
        return this.cells_;
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxFunction
    public Object insertCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber(index);
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (indexValid) {
            DomElement newCell = ((HtmlPage)htmlRow.getPage()).createElement("td");
            if (position == -1 || position == htmlRow.getCells().size()) {
                htmlRow.appendChild(newCell);
            } else {
                htmlRow.getCell(position).insertBefore(newCell);
            }
            return this.getScriptableFor(newCell);
        }
        throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
    }

    @JsxFunction
    public void deleteCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber(index);
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_172)) {
            throw Context.reportRuntimeError("No enough arguments");
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        if (position == -1) {
            position = htmlRow.getCells().size() - 1;
        }
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (!indexValid) {
            throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
        }
        htmlRow.getCell(position).remove();
    }

    @Override
    public String getDefaultStyleDisplay() {
        return "table-row";
    }
}

