/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.util.CharsetUtil;
import org.webbitserver.netty.FlashPolicyFileHandler;

public class FlashPolicyFileDecoder
extends FrameDecoder {
    private static final ChannelBuffer FLASH_POLICY_REQUEST = ChannelBuffers.copiedBuffer((CharSequence)"<policy-file-request/>\u0000", CharsetUtil.US_ASCII);
    private final Executor executor;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;
    private final int publicPort;

    public FlashPolicyFileDecoder(Executor executor, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler, int publicPort) {
        super(true);
        this.publicPort = publicPort;
        this.executor = executor;
        this.exceptionHandler = exceptionHandler;
        this.ioExceptionHandler = ioExceptionHandler;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() >= 23) {
            ChannelPipeline p = ctx.getPipeline();
            ChannelBuffer firstMessage = buffer.readBytes(23);
            if (((Object)FLASH_POLICY_REQUEST).equals(firstMessage)) {
                p.addAfter("flashpolicydecoder", "flashpolicyhandler", new FlashPolicyFileHandler(this.executor, this.exceptionHandler, this.ioExceptionHandler, this.publicPort));
            }
            p.remove(this);
            if (buffer.readable()) {
                return new Object[]{firstMessage, buffer.readBytes(buffer.readableBytes())};
            }
            return firstMessage;
        }
        return buffer.readBytes(buffer.readableBytes());
    }
}

