/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.logging;

import java.io.Flushable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Date;
import org.webbitserver.EventSourceConnection;
import org.webbitserver.HttpRequest;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.handler.logging.LogSink;
import org.webbitserver.helpers.Hex;

public class SimpleLogSink
implements LogSink {
    protected final Appendable out;
    protected final String[] dataValuesToLog;
    protected final String lineSeparator = System.getProperty("line.separator", "\n");
    protected boolean trouble = false;

    public SimpleLogSink(Appendable out, String ... dataValuesToLog) {
        this.out = out;
        this.dataValuesToLog = dataValuesToLog;
        try {
            this.formatHeader(out);
            this.flush();
        }
        catch (IOException e) {
            this.trouble = true;
            this.panic(e);
        }
    }

    public SimpleLogSink(String ... dataValuesToLog) {
        this(System.out, dataValuesToLog);
    }

    @Override
    public void httpStart(HttpRequest request) {
        this.custom(request, "HTTP-START", null);
    }

    @Override
    public void httpEnd(HttpRequest request) {
        this.custom(request, "HTTP-END", null);
    }

    @Override
    public void webSocketConnectionOpen(WebSocketConnection connection) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-OPEN", null);
    }

    @Override
    public void webSocketConnectionClose(WebSocketConnection connection) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-CLOSE", null);
    }

    @Override
    public void webSocketInboundData(WebSocketConnection connection, String data) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-IN-STRING", data);
    }

    @Override
    public void webSocketInboundData(WebSocketConnection connection, byte[] data) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-IN-HEX", Hex.toHex(data));
    }

    @Override
    public void webSocketInboundPing(WebSocketConnection connection, byte[] msg) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-IN-PING", Hex.toHex(msg));
    }

    @Override
    public void webSocketInboundPong(WebSocketConnection connection, byte[] msg) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-IN-PONG", Hex.toHex(msg));
    }

    @Override
    public void webSocketOutboundData(WebSocketConnection connection, String data) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-OUT-STRING", data);
    }

    @Override
    public void webSocketOutboundData(WebSocketConnection connection, byte[] data) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-OUT-HEX", Hex.toHex(data));
    }

    @Override
    public void webSocketOutboundPing(WebSocketConnection connection, byte[] msg) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-OUT-PING", Hex.toHex(msg));
    }

    @Override
    public void webSocketOutboundPong(WebSocketConnection connection, byte[] msg) {
        this.custom(connection.httpRequest(), "WEB-SOCKET-" + connection.version() + "-OUT-PONG", Hex.toHex(msg));
    }

    @Override
    public void error(HttpRequest request, Throwable error) {
        this.custom(request, "ERROR-OPEN", error.toString());
    }

    @Override
    public void custom(HttpRequest request, String action, String data) {
        if (this.trouble) {
            return;
        }
        try {
            this.formatLogEntry(this.out, request, action, data);
            this.flush();
        }
        catch (IOException e) {
            this.trouble = true;
            this.panic(e);
        }
    }

    @Override
    public void eventSourceConnectionOpen(EventSourceConnection connection) {
        this.custom(connection.httpRequest(), "EVENT-SOURCE-OPEN", null);
    }

    @Override
    public void eventSourceConnectionClose(EventSourceConnection connection) {
        this.custom(connection.httpRequest(), "EVENT-SOURCE-CLOSE", null);
    }

    @Override
    public void eventSourceOutboundData(EventSourceConnection connection, String data) {
        this.custom(connection.httpRequest(), "EVENT-SOURCE-OUT", data);
    }

    protected void flush() throws IOException {
        if (this.out instanceof Flushable) {
            Flushable flushable = (Flushable)((Object)this.out);
            flushable.flush();
        }
    }

    protected void panic(IOException exception) {
        exception.printStackTrace();
    }

    protected Appendable formatLogEntry(Appendable out, HttpRequest request, String action, String data) throws IOException {
        long cumulativeTimeOfRequest = this.cumulativeTimeOfRequest(request);
        Date now = new Date();
        this.formatValue(out, now);
        this.formatValue(out, now.getTime());
        this.formatValue(out, cumulativeTimeOfRequest);
        this.formatValue(out, request.id());
        this.formatValue(out, this.address(request.remoteAddress()));
        this.formatValue(out, action);
        this.formatValue(out, request.uri());
        this.formatValue(out, data);
        for (String key : this.dataValuesToLog) {
            this.formatValue(out, request.data(key));
        }
        return out.append(this.lineSeparator);
    }

    protected Appendable formatHeader(Appendable out) throws IOException {
        out.append("#Log started at ").append(new Date().toString()).append(" (").append(String.valueOf(System.currentTimeMillis())).append(")").append(this.lineSeparator).append('#');
        this.formatValue(out, "Date");
        this.formatValue(out, "Timestamp");
        this.formatValue(out, "MillsSinceRequestStart");
        this.formatValue(out, "RequestID");
        this.formatValue(out, "RemoteHost");
        this.formatValue(out, "Action");
        this.formatValue(out, "Path");
        this.formatValue(out, "Payload");
        for (String key : this.dataValuesToLog) {
            this.formatValue(out, "Data:" + key);
        }
        return out.append(this.lineSeparator);
    }

    private long cumulativeTimeOfRequest(HttpRequest request) {
        return System.currentTimeMillis() - request.timestamp();
    }

    protected Appendable formatValue(Appendable out, Object value) throws IOException {
        if (value == null) {
            return out.append("-\t");
        }
        String string = value.toString().trim();
        if (string.isEmpty()) {
            return out.append("-\t");
        }
        return out.append(string).append('\t');
    }

    protected String address(SocketAddress address) {
        return address.toString();
    }
}

