/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionInternetExplorerCustomProxyLauncher;

public class InternetExplorerLauncher
implements BrowserLauncher {
    final BrowserLauncher realLauncher;
    static final String DEFAULT_MODE = "iehta";

    public InternetExplorerLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        String mode = (String)browserOptions.getCapability("mode");
        if (mode == null) {
            mode = DEFAULT_MODE;
        }
        if ("default".equals(mode)) {
            mode = DEFAULT_MODE;
        }
        if (DEFAULT_MODE.equals(mode)) {
            this.realLauncher = new HTABrowserLauncher(browserOptions, configuration, sessionId, browserLaunchLocation);
            return;
        }
        boolean proxyInjectionMode = browserOptions.is("proxyInjectionMode") || "proxyInjection".equals(mode);
        boolean globalProxyInjectionMode = configuration.getProxyInjectionModeArg();
        if (proxyInjectionMode && !globalProxyInjectionMode && proxyInjectionMode) {
            throw new RuntimeException("You requested proxy injection mode, but this server wasn't configured with -proxyInjectionMode on the command line");
        }
        proxyInjectionMode = globalProxyInjectionMode;
        if (proxyInjectionMode) {
            this.realLauncher = new ProxyInjectionInternetExplorerCustomProxyLauncher(browserOptions, configuration, sessionId, browserLaunchLocation);
            return;
        }
        if (!"proxy".equals(mode)) {
            throw new RuntimeException("Unrecognized browser mode: " + mode);
        }
        this.realLauncher = new InternetExplorerCustomProxyLauncher(browserOptions, configuration, sessionId, browserLaunchLocation);
    }

    @Override
    public void close() {
        this.realLauncher.close();
    }

    @Override
    public void launchHTMLSuite(String suiteUrl, String baseUrl) {
        this.realLauncher.launchHTMLSuite(suiteUrl, baseUrl);
    }

    @Override
    public void launchRemoteSession(String url) {
        this.realLauncher.launchRemoteSession(url);
    }
}

