/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.htmlunit.AsyncScriptExecutor;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlUnitDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName,
FindsByCssSelector,
FindsByTagName,
HasCapabilities,
HasInputDevices {
    private WebClient webClient;
    private WebWindow currentWindow;
    private boolean enableJavascript;
    private ProxyConfig proxyConfig;
    private long implicitWait = 0L;
    private long scriptTimeout = 0L;
    private HtmlUnitKeyboard keyboard;
    private HtmlUnitMouse mouse;
    private boolean gotPage;
    public static final String INVALIDXPATHERROR = "The xpath expression '%s' cannot be evaluated";
    public static final String INVALIDSELECTIONERROR = "The xpath expression '%s' selected an object of type '%s' instead of a WebElement";

    public HtmlUnitDriver(BrowserVersion version) {
        this.webClient = this.createWebClient(version);
        this.currentWindow = this.webClient.getCurrentWindow();
        this.webClient.addWebWindowListener(new WebWindowListener(){

            @Override
            public void webWindowOpened(WebWindowEvent webWindowEvent) {
            }

            @Override
            public void webWindowContentChanged(WebWindowEvent event) {
                if (event.getWebWindow() != HtmlUnitDriver.this.currentWindow) {
                    return;
                }
                HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow);
            }

            @Override
            public void webWindowClosed(WebWindowEvent event) {
                WebWindow curr = HtmlUnitDriver.this.currentWindow;
                do {
                    if (curr != event.getWebWindow()) continue;
                    HtmlUnitDriver.this.currentWindow = HtmlUnitDriver.this.currentWindow.getTopWindow();
                    return;
                } while ((curr = curr.getParentWindow()) != HtmlUnitDriver.this.currentWindow.getTopWindow());
            }
        });
        this.get(this.webClient.getOptions().getHomePage());
        this.gotPage = false;
        this.resetKeyboardAndMouseState();
    }

    public HtmlUnitDriver() {
        this(false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault());
        this.setJavascriptEnabled(enableJavascript);
    }

    public HtmlUnitDriver(Capabilities capabilities) {
        this(HtmlUnitDriver.determineBrowserVersion(capabilities));
        Proxy proxy;
        String fullProxy;
        this.setJavascriptEnabled(capabilities.isJavascriptEnabled());
        if (capabilities.getCapability("proxy") != null && (fullProxy = (proxy = Proxies.extractProxy(capabilities)).getHttpProxy()) != null) {
            int index = fullProxy.indexOf(":");
            if (index != -1) {
                String host = fullProxy.substring(0, index);
                int port = Integer.parseInt(fullProxy.substring(index + 1));
                this.setProxy(host, port);
            } else {
                this.setProxy(fullProxy, 0);
            }
        }
    }

    static BrowserVersion determineBrowserVersion(Capabilities capabilities) {
        String[] splitVersion;
        String browserName = null;
        String browserVersion = null;
        String rawVersion = capabilities.getVersion();
        String[] stringArray = splitVersion = rawVersion == null ? new String[]{} : rawVersion.split("-");
        if (splitVersion.length > 1) {
            browserVersion = splitVersion[1];
            browserName = splitVersion[0];
        } else {
            browserName = capabilities.getVersion();
            browserVersion = "";
        }
        if (!"htmlunit".equals(capabilities.getBrowserName())) {
            browserName = capabilities.getBrowserName();
            browserVersion = capabilities.getVersion();
        }
        if ("firefox".equals(browserName)) {
            if (browserVersion != null && (browserVersion.equals("3") || browserVersion.startsWith("3."))) {
                return BrowserVersion.FIREFOX_3_6;
            }
            return BrowserVersion.FIREFOX_10;
        }
        if ("internet explorer".equals(browserName)) {
            try {
                int version = Integer.parseInt(browserVersion);
                switch (version) {
                    case 6: {
                        return BrowserVersion.INTERNET_EXPLORER_6;
                    }
                    case 7: {
                        return BrowserVersion.INTERNET_EXPLORER_7;
                    }
                    case 8: {
                        return BrowserVersion.INTERNET_EXPLORER_8;
                    }
                }
                return BrowserVersion.INTERNET_EXPLORER_8;
            }
            catch (NumberFormatException numberFormatException) {
                return BrowserVersion.INTERNET_EXPLORER_8;
            }
        }
        return BrowserVersion.FIREFOX_10;
    }

    private WebClient createWebClient(BrowserVersion version) {
        WebClient client = this.newWebClient(version);
        WebClientOptions options = client.getOptions();
        options.setHomePage(WebClient.URL_ABOUT_BLANK.toString());
        options.setThrowExceptionOnFailingStatusCode(false);
        options.setPrintContentOnFailingStatusCode(false);
        options.setJavaScriptEnabled(this.enableJavascript);
        options.setRedirectEnabled(true);
        options.setUseInsecureSSL(true);
        if (this.proxyConfig != null) {
            options.setProxyConfig(this.proxyConfig);
        }
        client.setRefreshHandler(new WaitingRefreshHandler());
        return this.modifyWebClient(client);
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public void setProxy(String host, int port) {
        this.proxyConfig = new ProxyConfig(host, port);
        this.webClient.getOptions().setProxyConfig(this.proxyConfig);
    }

    public void setAutoProxy(String autoProxyUrl) {
        this.proxyConfig = new ProxyConfig();
        this.proxyConfig.setProxyAutoConfigUrl(autoProxyUrl);
        this.webClient.getOptions().setProxyConfig(this.proxyConfig);
    }

    @Override
    public Capabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setPlatform(Platform.getCurrent());
        capabilities.setJavascriptEnabled(this.isJavascriptEnabled());
        capabilities.setCapability("cssSelectorsEnabled", true);
        return capabilities;
    }

    @Override
    public void get(String url) {
        URL fullUrl;
        if (WebClient.URL_ABOUT_BLANK.toString().equals(url)) {
            this.get(WebClient.URL_ABOUT_BLANK);
            return;
        }
        try {
            fullUrl = new URL(url);
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
        this.get(fullUrl);
    }

    protected void get(URL fullUrl) {
        try {
            this.currentWindow = this.currentWindow.getTopWindow();
            this.webClient.getPage(fullUrl);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (ConnectException connectException) {
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
        this.gotPage = true;
        this.pickWindow();
        this.resetKeyboardAndMouseState();
    }

    private void resetKeyboardAndMouseState() {
        this.keyboard = new HtmlUnitKeyboard(this);
        this.mouse = new HtmlUnitMouse(this, this.keyboard);
    }

    protected void pickWindow() {
        if (this.currentWindow == null) {
            this.currentWindow = this.webClient.getCurrentWindow();
        }
    }

    @Override
    public String getCurrentUrl() {
        URL url = this.getRawUrl();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    @Override
    public String getTitle() {
        Page page = this.lastPage();
        if (page == null || !(page instanceof HtmlPage)) {
            return null;
        }
        if (this.currentWindow instanceof FrameWindow) {
            page = ((FrameWindow)this.currentWindow).getTopWindow().getEnclosedPage();
        }
        return ((HtmlPage)page).getTitleText();
    }

    @Override
    public WebElement findElement(By by) {
        return this.findElement(by, this);
    }

    @Override
    public List<WebElement> findElements(By by) {
        return this.findElements(by, this);
    }

    @Override
    public String getPageSource() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        if (page instanceof SgmlPage) {
            return ((SgmlPage)page).asXml();
        }
        WebResponse response = page.getWebResponse();
        return response.getContentAsString();
    }

    @Override
    public void close() {
        if (this.currentWindow != null) {
            ((TopLevelWindow)this.currentWindow.getTopWindow()).close();
        }
        if (this.webClient.getWebWindows().size() == 0) {
            this.quit();
        }
    }

    @Override
    public void quit() {
        if (this.webClient != null) {
            this.webClient.closeAllWindows();
            this.webClient = null;
        }
        this.currentWindow = null;
    }

    @Override
    public Set<String> getWindowHandles() {
        HashSet<String> allHandles = new HashSet<String>();
        for (WebWindow webWindow : this.webClient.getTopLevelWindows()) {
            allHandles.add(String.valueOf(System.identityHashCode(webWindow)));
        }
        return allHandles;
    }

    @Override
    public String getWindowHandle() {
        WebWindow topWindow = this.currentWindow.getTopWindow();
        if (topWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return String.valueOf(System.identityHashCode(topWindow));
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        script = "function() {" + script + "\n};";
        ScriptResult result = page.executeJavaScript(script);
        net.sourceforge.htmlunit.corejs.javascript.Function func = (net.sourceforge.htmlunit.corejs.javascript.Function)result.getJavaScriptResult();
        Object[] parameters = this.convertScriptArgs(page, args);
        result = page.executeJavaScriptFunctionIfPossible(func, (ScriptableObject)this.currentWindow.getScriptObject(), parameters, page.getDocumentElement());
        return this.parseNativeJavascriptResult(result);
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        args = this.convertScriptArgs(page, args);
        Object result = new AsyncScriptExecutor(page, this.scriptTimeout).execute(script, args);
        return this.parseNativeJavascriptResult(result);
    }

    private Object[] convertScriptArgs(HtmlPage page, final Object[] args) {
        final Scriptable scope = (Scriptable)page.getEnclosingWindow().getScriptObject();
        final Object[] parameters = new Object[args.length];
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context context) {
                int i = 0;
                while (i < args.length) {
                    parameters[i] = HtmlUnitDriver.this.parseArgumentIntoJavsacriptParameter(context, scope, args[i]);
                    ++i;
                }
                return null;
            }
        };
        this.webClient.getJavaScriptEngine().getContextFactory().call(action);
        return parameters;
    }

    private HtmlPage getPageToInjectScriptInto() {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        if (!this.gotPage) {
            throw new WebDriverException("Can't execute JavaScript before a page has been loaded!");
        }
        return (HtmlPage)lastPage;
    }

    private Object parseArgumentIntoJavsacriptParameter(Context context, Scriptable scope, Object arg) {
        while (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (!(arg instanceof HtmlUnitWebElement || arg instanceof HtmlElement || arg instanceof Number || arg instanceof String || arg instanceof Boolean || arg.getClass().isArray() || arg instanceof Collection)) {
            throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + arg + " (" + arg.getClass() + ")");
        }
        if (arg instanceof HtmlUnitWebElement) {
            HtmlElement element = ((HtmlUnitWebElement)arg).getElement();
            return element.getScriptObject();
        }
        if (arg instanceof HtmlElement) {
            return ((HtmlElement)arg).getScriptObject();
        }
        if (arg instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                list.add(this.parseArgumentIntoJavsacriptParameter(context, scope, o));
            }
            return context.newArray(scope, list.toArray());
        }
        return arg;
    }

    @Override
    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    @Override
    public Mouse getMouse() {
        return this.mouse;
    }

    private Object parseNativeJavascriptResult(Object result) {
        Object value = result instanceof ScriptResult ? ((ScriptResult)result).getJavaScriptResult() : result;
        if (value instanceof HTMLElement) {
            return this.newHtmlUnitWebElement(((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            String string = n.toString();
            if (string.indexOf(".") == -1 || string.endsWith(".0")) {
                return n.longValue();
            }
            return n.doubleValue();
        }
        if (value instanceof NativeObject) {
            HashMap map = new HashMap((NativeObject)value);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.parseNativeJavascriptResult(entry.getValue()));
            }
            return map;
        }
        if (value instanceof NativeArray) {
            final NativeArray array = (NativeArray)value;
            JavaScriptResultsCollection javaScriptResultsCollection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return (int)array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get(index);
                }
            };
            return this.parseJavascriptResultsList(javaScriptResultsCollection);
        }
        if (value instanceof HTMLCollection) {
            final HTMLCollection array = (HTMLCollection)value;
            JavaScriptResultsCollection javaScriptResultsCollection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get(index);
                }
            };
            return this.parseJavascriptResultsList(javaScriptResultsCollection);
        }
        if (value instanceof Undefined) {
            return null;
        }
        return value;
    }

    private List<Object> parseJavascriptResultsList(JavaScriptResultsCollection array) {
        ArrayList<Object> list = new ArrayList<Object>(array.getLength());
        int i = 0;
        while (i < array.getLength()) {
            list.add(this.parseNativeJavascriptResult(array.item(i)));
            ++i;
        }
        return list;
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new HtmlUnitTargetLocator();
    }

    private void switchToDefaultContentOfWindow(WebWindow window) {
        Page page = window.getEnclosedPage();
        if (page instanceof HtmlPage) {
            this.currentWindow = window;
        }
    }

    @Override
    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected Page lastPage() {
        return this.currentWindow.getEnclosedPage();
    }

    @Override
    public WebElement findElementByLinkText(String selector) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        String expectedText = selector.trim();
        List<HtmlAnchor> anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText().trim())) continue;
            return this.newHtmlUnitWebElement(anchor);
        }
        throw new NoSuchElementException("No link found with text: " + expectedText);
    }

    protected WebElement newHtmlUnitWebElement(HtmlElement element) {
        return new HtmlUnitWebElement(this, element);
    }

    @Override
    public List<WebElement> findElementsByLinkText(String selector) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (!(this.lastPage() instanceof HtmlPage)) {
            return elements;
        }
        String expectedText = selector.trim();
        List<HtmlAnchor> anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText().trim())) continue;
            elements.add(this.newHtmlUnitWebElement(anchor));
        }
        return elements;
    }

    @Override
    public WebElement findElementById(String id) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element by id for " + this.lastPage());
        }
        try {
            Object element = ((HtmlPage)this.lastPage()).getHtmlElementById(id);
            return this.newHtmlUnitWebElement((HtmlElement)element);
        }
        catch (ElementNotFoundException elementNotFoundException) {
            throw new NoSuchElementException("Unable to locate element with ID: " + id);
        }
    }

    @Override
    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath("//*[@id='" + id + "']");
    }

    @Override
    public WebElement findElementByCssSelector(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + this.lastPage());
        }
        DomNode node = ((HtmlPage)this.lastPage()).querySelector(using);
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new NoSuchElementException("Returned node was not an HTML element");
    }

    @Override
    public List<WebElement> findElementsByCssSelector(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + this.lastPage());
        }
        DomNodeList<DomNode> allNodes = ((HtmlPage)this.lastPage()).querySelectorAll(using);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (DomNode node : allNodes) {
            if (node instanceof HtmlElement) {
                toReturn.add(this.newHtmlUnitWebElement((HtmlElement)node));
                continue;
            }
            throw new NoSuchElementException("Returned node was not an HTML element");
        }
        return toReturn;
    }

    @Override
    public WebElement findElementByName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + this.lastPage());
        }
        List<DomElement> allElements = ((HtmlPage)this.lastPage()).getElementsByName(name);
        if (!allElements.isEmpty()) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.get(0));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    @Override
    public List<WebElement> findElementsByName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List<DomElement> allElements = ((HtmlPage)this.lastPage()).getElementsByName(using);
        return this.convertRawHtmlElementsToWebElements(allElements);
    }

    @Override
    public WebElement findElementByTagName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + this.lastPage());
        }
        NodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(name);
        if (allElements.getLength() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.item(0));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    @Override
    public List<WebElement> findElementsByTagName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        NodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(using);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
        int i = 0;
        while (i < allElements.getLength()) {
            Node item = allElements.item(i);
            if (item instanceof HtmlElement) {
                toReturn.add(this.newHtmlUnitWebElement((HtmlElement)item));
            }
            ++i;
        }
        return toReturn;
    }

    @Override
    public WebElement findElementByXPath(String selector) {
        Object node;
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by xpath for " + this.lastPage());
        }
        try {
            node = ((HtmlPage)this.lastPage()).getFirstByXPath(selector);
        }
        catch (Exception ex) {
            throw new InvalidSelectorException(String.format(INVALIDXPATHERROR, selector), ex);
        }
        if (node == null) {
            throw new NoSuchElementException("Unable to locate a node using " + selector);
        }
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new InvalidSelectorException(String.format(INVALIDSELECTIONERROR, selector, node.getClass()));
    }

    @Override
    public List<WebElement> findElementsByXPath(String selector) {
        List<WebElement> result;
        List<?> nodes;
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        try {
            nodes = ((HtmlPage)this.lastPage()).getByXPath(selector);
            result = this.convertRawHtmlElementsToWebElements(nodes);
        }
        catch (RuntimeException ex) {
            throw new InvalidSelectorException(String.format(INVALIDXPATHERROR, selector), ex);
        }
        if (nodes.size() != result.size()) {
            for (Object node : nodes) {
                if (node instanceof HtmlElement) continue;
                throw new InvalidSelectorException(String.format(INVALIDSELECTIONERROR, selector, node.getClass()));
            }
        }
        return result;
    }

    private List<WebElement> convertRawHtmlElementsToWebElements(List<?> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object node : nodes) {
            if (!(node instanceof HtmlElement)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)node));
        }
        return elements;
    }

    public boolean isJavascriptEnabled() {
        return this.webClient.getOptions().isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
        this.webClient.getOptions().setJavaScriptEnabled(enableJavascript);
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        long end = System.currentTimeMillis() + this.implicitWait;
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException(lastException);
        }
        return null;
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        return this.currentWindow;
    }

    private URL getRawUrl() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        return page.getUrl();
    }

    @Override
    public WebDriver.Options manage() {
        return new HtmlUnitOptions();
    }

    @Override
    public WebElement findElementByPartialLinkText(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List<HtmlAnchor> anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asText().contains(using)) continue;
            return this.newHtmlUnitWebElement(anchor);
        }
        throw new NoSuchElementException("No link found with text: " + using);
    }

    @Override
    public List<WebElement> findElementsByPartialLinkText(String using) {
        List<HtmlAnchor> anchors = ((HtmlPage)this.lastPage()).getAnchors();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asText().contains(using)) continue;
            elements.add(this.newHtmlUnitWebElement(anchor));
        }
        return elements;
    }

    WebElement findElement(final By locator, final SearchContext context) {
        return this.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return locator.findElement(context);
            }
        });
    }

    List<WebElement> findElements(By by, SearchContext context) {
        List<WebElement> found;
        long end = System.currentTimeMillis() + this.implicitWait;
        do {
            if ((found = by.findElements(context)).isEmpty()) continue;
            return found;
        } while (System.currentTimeMillis() < end);
        return found;
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {}
    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        @Override
        public void back() {
            try {
                HtmlUnitDriver.this.currentWindow.getHistory().back();
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }

        @Override
        public void forward() {
            try {
                HtmlUnitDriver.this.currentWindow.getHistory().forward();
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }

        @Override
        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        @Override
        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        @Override
        public void refresh() {
            if (HtmlUnitDriver.this.lastPage() instanceof HtmlPage) {
                try {
                    ((HtmlPage)HtmlUnitDriver.this.lastPage()).refresh();
                }
                catch (IOException e) {
                    throw new WebDriverException(e);
                }
            }
        }
    }

    private class HtmlUnitOptions
    implements WebDriver.Options {
        private final Function<? super com.gargoylesoftware.htmlunit.util.Cookie, Cookie> htmlUnitCookieToSeleniumCookieTransformer = new Function<com.gargoylesoftware.htmlunit.util.Cookie, Cookie>(){

            @Override
            public Cookie apply(com.gargoylesoftware.htmlunit.util.Cookie c) {
                return new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).build();
            }
        };

        private HtmlUnitOptions() {
        }

        @Override
        public Logs logs() {
            throw new UnsupportedOperationException("Driver does not support this operation.");
        }

        @Override
        public void addCookie(Cookie cookie) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (!(page instanceof HtmlPage)) {
                throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
            }
            String domain = this.getDomainForCookie();
            this.verifyDomain(cookie, domain);
            HtmlUnitDriver.this.webClient.getCookieManager().addCookie(new com.gargoylesoftware.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
        }

        private void verifyDomain(Cookie cookie, String expectedDomain) {
            String domain = cookie.getDomain();
            if (domain == null) {
                return;
            }
            if ("".equals(domain)) {
                throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
            }
            if (domain.matches(".*[^:]:\\d+$")) {
                domain = domain.replaceFirst(":\\d+$", "");
            }
            expectedDomain = expectedDomain.startsWith(".") ? expectedDomain : "." + expectedDomain;
            String string = domain = domain.startsWith(".") ? domain : "." + domain;
            if (!expectedDomain.endsWith(domain)) {
                throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
            }
        }

        @Override
        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
            return null;
        }

        @Override
        public void deleteCookieNamed(String name) {
            CookieManager cookieManager = HtmlUnitDriver.this.webClient.getCookieManager();
            URL url = HtmlUnitDriver.this.getRawUrl();
            Set<com.gargoylesoftware.htmlunit.util.Cookie> rawCookies = HtmlUnitDriver.this.webClient.getCookieManager().getCookies(url);
            for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
                if (!name.equals(cookie.getName())) continue;
                cookieManager.removeCookie(cookie);
            }
        }

        @Override
        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        @Override
        public void deleteAllCookies() {
            HtmlUnitDriver.this.webClient.getCookieManager().clearCookies();
        }

        @Override
        public Set<Cookie> getCookies() {
            URL url = HtmlUnitDriver.this.getRawUrl();
            if (!url.toString().startsWith("http")) {
                return new HashSet<Cookie>();
            }
            return ImmutableSet.copyOf(Collections2.transform(HtmlUnitDriver.this.webClient.getCookieManager().getCookies(url), this.htmlUnitCookieToSeleniumCookieTransformer));
        }

        private String getDomainForCookie() {
            URL current = HtmlUnitDriver.this.getRawUrl();
            return current.getHost();
        }

        @Override
        public WebDriver.Timeouts timeouts() {
            return new HtmlUnitTimeouts();
        }

        @Override
        public WebDriver.ImeHandler ime() {
            throw new UnsupportedOperationException("Cannot input IME using HtmlUnit.");
        }

        @Override
        public WebDriver.Window window() {
            throw new UnsupportedOperationException("Window handling not yet implemented in HtmlUnit");
        }
    }

    private class HtmlUnitTargetLocator
    implements WebDriver.TargetLocator {
        private HtmlUnitTargetLocator() {
        }

        @Override
        public WebDriver frame(int index) {
            HtmlPage currentPage = (HtmlPage)HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            try {
                HtmlUnitDriver.this.currentWindow = currentPage.getFrames().get(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchFrameException("Cannot find frame: " + index);
            }
            return HtmlUnitDriver.this;
        }

        @Override
        public WebDriver frame(String nameOrId) {
            HtmlPage startPage = (HtmlPage)HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            for (FrameWindow frameWindow : startPage.getFrames()) {
                if (!frameWindow.getName().equals(nameOrId)) continue;
                HtmlUnitDriver.this.currentWindow = frameWindow;
                return HtmlUnitDriver.this;
            }
            try {
                HtmlUnitWebElement element = (HtmlUnitWebElement)HtmlUnitDriver.this.findElementById(nameOrId);
                HtmlElement domElement = element.getElement();
                if (domElement instanceof BaseFrameElement) {
                    HtmlUnitDriver.this.currentWindow = ((BaseFrameElement)domElement).getEnclosedWindow();
                    return HtmlUnitDriver.this;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            throw new NoSuchFrameException("Unable to locate frame with name or ID: " + nameOrId);
        }

        @Override
        public WebDriver frame(WebElement frameElement) {
            while (frameElement instanceof WrapsElement) {
                frameElement = ((WrapsElement)((Object)frameElement)).getWrappedElement();
            }
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)frameElement;
            webElement.assertElementNotStale();
            HtmlElement domElement = webElement.getElement();
            if (!(domElement instanceof BaseFrameElement)) {
                throw new NoSuchFrameException(String.valueOf(webElement.getTagName()) + " is not a frame element.");
            }
            HtmlUnitDriver.this.currentWindow = ((BaseFrameElement)domElement).getEnclosedWindow();
            return HtmlUnitDriver.this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public WebDriver window(String windowId) {
            try {
                window = HtmlUnitDriver.access$2(HtmlUnitDriver.this).getWebWindowByName(windowId);
                return this.finishSelecting(window);
            }
            catch (WebWindowNotFoundException v0) {
                allWindows = HtmlUnitDriver.access$2(HtmlUnitDriver.this).getWebWindows();
                ** for (current : allWindows)
            }
lbl-1000:
            // 1 sources

            {
                top = current.getTopWindow();
                if (!String.valueOf(System.identityHashCode(top)).equals(windowId)) continue;
                return this.finishSelecting(top);
            }
lbl10:
            // 1 sources

            throw new NoSuchWindowException("Cannot find window: " + windowId);
        }

        private WebDriver finishSelecting(WebWindow window) {
            HtmlUnitDriver.this.webClient.setCurrentWindow(window);
            HtmlUnitDriver.this.currentWindow = window;
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        @Override
        public WebDriver defaultContent() {
            HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow.getTopWindow());
            return HtmlUnitDriver.this;
        }

        @Override
        public WebElement activeElement() {
            Page page = HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            if (page instanceof HtmlPage) {
                HtmlElement element = ((HtmlPage)page).getFocusedElement();
                if (element == null) {
                    List allBodies = ((HtmlPage)page).getDocumentElement().getHtmlElementsByTagName("body");
                    if (!allBodies.isEmpty()) {
                        return HtmlUnitDriver.this.newHtmlUnitWebElement((HtmlElement)allBodies.get(0));
                    }
                } else {
                    return HtmlUnitDriver.this.newHtmlUnitWebElement(element);
                }
            }
            throw new NoSuchElementException("Unable to locate element with focus or body tag");
        }

        @Override
        public Alert alert() {
            throw new UnsupportedOperationException("alert()");
        }
    }

    class HtmlUnitTimeouts
    implements WebDriver.Timeouts {
        HtmlUnitTimeouts() {
        }

        @Override
        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            HtmlUnitDriver.this.implicitWait = TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit);
            return this;
        }

        @Override
        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            HtmlUnitDriver.this.scriptTimeout = TimeUnit.MILLISECONDS.convert(time, unit);
            return this;
        }

        @Override
        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            throw new UnsupportedOperationException("pageLoadTimeout");
        }
    }

    protected static interface JavaScriptResultsCollection {
        public int getLength();

        public Object item(int var1);
    }
}

