/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;

public abstract class SingleBrowserLocator
implements BrowserLocator {
    private static final Logger log = Logger.getLogger(BrowserLocator.class.getName());

    @Override
    public BrowserInstallation findBrowserLocationOrFail() {
        BrowserInstallation location = this.findBrowserLocation();
        if (location == null) {
            throw new RuntimeException(this.couldNotFindAnyInstallationMessage());
        }
        return location;
    }

    public BrowserInstallation findBrowserLocation() {
        log.fine("Discovering " + this.browserName() + "...");
        BrowserInstallation defaultPath = this.findAtADefaultLocation();
        if (defaultPath != null) {
            return defaultPath;
        }
        return this.findInPath();
    }

    protected abstract String browserName();

    protected abstract String[] standardlauncherFilenames();

    protected abstract String seleniumBrowserName();

    protected abstract String browserPathOverridePropertyName();

    protected abstract String[] usualLauncherLocations();

    protected BrowserInstallation findInPath() {
        String[] stringArray = this.standardlauncherFilenames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String launcherFilename = stringArray[n2];
            BrowserInstallation launcherPath = this.findFileInPath(launcherFilename);
            if (launcherPath != null) {
                return launcherPath;
            }
            ++n2;
        }
        return null;
    }

    protected BrowserInstallation findAtADefaultLocation() {
        return this.browserDefaultPath();
    }

    protected BrowserInstallation browserDefaultPath() {
        String userProvidedDefaultPath = System.getProperty(this.browserPathOverridePropertyName());
        if (userProvidedDefaultPath != null) {
            return this.retrieveValidInstallationPath(userProvidedDefaultPath);
        }
        String[] stringArray = this.usualLauncherLocations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            String[] stringArray2 = this.standardlauncherFilenames();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                BrowserInstallation validInstallationPath = this.retrieveValidInstallationPath(location, fileName);
                if (validInstallationPath != null) {
                    return validInstallationPath;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public BrowserInstallation findFileInPath(String fileName) {
        return this.retrieveValidInstallationPath(CommandLine.find(fileName));
    }

    protected String couldNotFindAnyInstallationMessage() {
        return String.valueOf(this.browserName()) + " could not be found in the path!\n" + "Please add the directory containing '" + this.humanFriendlyLauncherFileNames() + "' to your PATH environment\n" + "variable, or explicitly specify a path to " + this.browserName() + " like this:\n" + "*" + this.seleniumBrowserName() + " " + this.fakeLauncherPath();
    }

    protected String fakeLauncherPath() {
        if (WindowsUtils.thisIsWindows()) {
            return "c:\\blah\\" + this.standardlauncherFilenames()[0];
        }
        return "/blah/blah/" + this.standardlauncherFilenames()[0];
    }

    protected String humanFriendlyLauncherFileNames() {
        String[] fileNames = this.standardlauncherFilenames();
        if (fileNames.length == 0) {
            return "";
        }
        if (1 == fileNames.length) {
            return "'" + fileNames[0] + "'";
        }
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            buffer.append("'").append(filename).append("'");
            buffer.append(" or ");
            ++n2;
        }
        return buffer.substring(0, buffer.lastIndexOf(" or "));
    }

    protected BrowserInstallation retrieveValidInstallationPath(String dirname, String fileName) {
        return this.retrieveValidInstallationPath(new File(dirname, fileName));
    }

    @Override
    public BrowserInstallation retrieveValidInstallationPath(String launcher) {
        if (launcher == null) {
            return null;
        }
        return this.retrieveValidInstallationPath(new File(launcher));
    }

    protected BrowserInstallation retrieveValidInstallationPath(File launcher) {
        if (launcher == null) {
            return null;
        }
        log.fine("Checking whether " + this.browserName() + " launcher at :'" + launcher + "' is valid...");
        if (!launcher.exists()) {
            return null;
        }
        if (LauncherUtils.isScriptFile(launcher)) {
            log.warning("Caution: '" + launcher.getAbsolutePath() + "': file is a script file, not a real executable.  The browser environment is no longer fully under RC control");
        }
        log.fine("Discovered valid " + this.browserName() + " launcher  : '" + launcher + "'");
        return new BrowserInstallation(launcher.getAbsolutePath(), this.computeLibraryPath(launcher));
    }

    public String computeLibraryPath(File launcherPath) {
        if (WindowsUtils.thisIsWindows()) {
            return null;
        }
        String libraryPathEnvironmentVariable = CommandLine.getLibraryPathPropertyName();
        String currentLibraryPath = WindowsUtils.loadEnvironment().getProperty(libraryPathEnvironmentVariable);
        return String.valueOf(currentLibraryPath) + File.pathSeparator + launcherPath.getParent();
    }
}

