/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import org.openqa.selenium.browserlaunchers.locators.SingleBrowserLocator;
import org.openqa.selenium.os.WindowsUtils;

public class GoogleChromeLocator
extends SingleBrowserLocator {
    @Override
    protected String browserName() {
        return "Google Chrome";
    }

    @Override
    protected String seleniumBrowserName() {
        return "googlechrome";
    }

    @Override
    protected String[] standardlauncherFilenames() {
        return new String[]{"chrome.exe", "google-chrome", "Google Chrome"};
    }

    @Override
    protected String browserPathOverridePropertyName() {
        return "googleChromeDefaultPath";
    }

    @Override
    protected String[] usualLauncherLocations() {
        return WindowsUtils.thisIsWindows() ? this.usualWindowsLauncherLocations() : this.usualUnixLauncherLocations();
    }

    protected String[] usualWindowsLauncherLocations() {
        return new String[]{String.valueOf(WindowsUtils.getLocalAppDataPath()) + "\\Google\\Chrome\\Application"};
    }

    protected String[] usualUnixLauncherLocations() {
        return new String[]{"/usr/bin", "/Applications/Google Chrome.app/Contents/MacOS"};
    }
}

