/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import java.util.Map;
import org.openqa.selenium.ExplodingSupplier;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.seleniumemulation.AddLocationStrategy;
import org.openqa.selenium.internal.seleniumemulation.AddSelection;
import org.openqa.selenium.internal.seleniumemulation.AlertOverride;
import org.openqa.selenium.internal.seleniumemulation.AllowNativeXPath;
import org.openqa.selenium.internal.seleniumemulation.AltKeyDown;
import org.openqa.selenium.internal.seleniumemulation.AltKeyUp;
import org.openqa.selenium.internal.seleniumemulation.AssignId;
import org.openqa.selenium.internal.seleniumemulation.AttachFile;
import org.openqa.selenium.internal.seleniumemulation.CaptureScreenshotToString;
import org.openqa.selenium.internal.seleniumemulation.Check;
import org.openqa.selenium.internal.seleniumemulation.Click;
import org.openqa.selenium.internal.seleniumemulation.ClickAt;
import org.openqa.selenium.internal.seleniumemulation.Close;
import org.openqa.selenium.internal.seleniumemulation.CompoundMutator;
import org.openqa.selenium.internal.seleniumemulation.ControlKeyDown;
import org.openqa.selenium.internal.seleniumemulation.ControlKeyUp;
import org.openqa.selenium.internal.seleniumemulation.CreateCookie;
import org.openqa.selenium.internal.seleniumemulation.DeleteAllVisibleCookies;
import org.openqa.selenium.internal.seleniumemulation.DeleteCookie;
import org.openqa.selenium.internal.seleniumemulation.DeselectPopUp;
import org.openqa.selenium.internal.seleniumemulation.DoubleClick;
import org.openqa.selenium.internal.seleniumemulation.DragAndDrop;
import org.openqa.selenium.internal.seleniumemulation.DragAndDropToObject;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.FindFirstSelectedOptionProperty;
import org.openqa.selenium.internal.seleniumemulation.FindSelectedOptionProperties;
import org.openqa.selenium.internal.seleniumemulation.FireEvent;
import org.openqa.selenium.internal.seleniumemulation.FireNamedEvent;
import org.openqa.selenium.internal.seleniumemulation.GetAlert;
import org.openqa.selenium.internal.seleniumemulation.GetAllButtons;
import org.openqa.selenium.internal.seleniumemulation.GetAllFields;
import org.openqa.selenium.internal.seleniumemulation.GetAllLinks;
import org.openqa.selenium.internal.seleniumemulation.GetAllWindowNames;
import org.openqa.selenium.internal.seleniumemulation.GetAllWindowTitles;
import org.openqa.selenium.internal.seleniumemulation.GetAttribute;
import org.openqa.selenium.internal.seleniumemulation.GetAttributeFromAllWindows;
import org.openqa.selenium.internal.seleniumemulation.GetBodyText;
import org.openqa.selenium.internal.seleniumemulation.GetConfirmation;
import org.openqa.selenium.internal.seleniumemulation.GetCookie;
import org.openqa.selenium.internal.seleniumemulation.GetCookieByName;
import org.openqa.selenium.internal.seleniumemulation.GetCssCount;
import org.openqa.selenium.internal.seleniumemulation.GetElementHeight;
import org.openqa.selenium.internal.seleniumemulation.GetElementIndex;
import org.openqa.selenium.internal.seleniumemulation.GetElementPositionLeft;
import org.openqa.selenium.internal.seleniumemulation.GetElementPositionTop;
import org.openqa.selenium.internal.seleniumemulation.GetElementWidth;
import org.openqa.selenium.internal.seleniumemulation.GetEval;
import org.openqa.selenium.internal.seleniumemulation.GetExpression;
import org.openqa.selenium.internal.seleniumemulation.GetHtmlSource;
import org.openqa.selenium.internal.seleniumemulation.GetLocation;
import org.openqa.selenium.internal.seleniumemulation.GetSelectOptions;
import org.openqa.selenium.internal.seleniumemulation.GetTable;
import org.openqa.selenium.internal.seleniumemulation.GetText;
import org.openqa.selenium.internal.seleniumemulation.GetTitle;
import org.openqa.selenium.internal.seleniumemulation.GetValue;
import org.openqa.selenium.internal.seleniumemulation.GetXpathCount;
import org.openqa.selenium.internal.seleniumemulation.GoBack;
import org.openqa.selenium.internal.seleniumemulation.Highlight;
import org.openqa.selenium.internal.seleniumemulation.IsAlertPresent;
import org.openqa.selenium.internal.seleniumemulation.IsChecked;
import org.openqa.selenium.internal.seleniumemulation.IsConfirmationPresent;
import org.openqa.selenium.internal.seleniumemulation.IsCookiePresent;
import org.openqa.selenium.internal.seleniumemulation.IsEditable;
import org.openqa.selenium.internal.seleniumemulation.IsElementPresent;
import org.openqa.selenium.internal.seleniumemulation.IsOrdered;
import org.openqa.selenium.internal.seleniumemulation.IsSomethingSelected;
import org.openqa.selenium.internal.seleniumemulation.IsTextPresent;
import org.openqa.selenium.internal.seleniumemulation.IsVisible;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.internal.seleniumemulation.KeyEvent;
import org.openqa.selenium.internal.seleniumemulation.KeyState;
import org.openqa.selenium.internal.seleniumemulation.MetaKeyDown;
import org.openqa.selenium.internal.seleniumemulation.MetaKeyUp;
import org.openqa.selenium.internal.seleniumemulation.MouseEvent;
import org.openqa.selenium.internal.seleniumemulation.MouseEventAt;
import org.openqa.selenium.internal.seleniumemulation.NoOp;
import org.openqa.selenium.internal.seleniumemulation.Open;
import org.openqa.selenium.internal.seleniumemulation.OpenWindow;
import org.openqa.selenium.internal.seleniumemulation.Refresh;
import org.openqa.selenium.internal.seleniumemulation.RemoveAllSelections;
import org.openqa.selenium.internal.seleniumemulation.RemoveSelection;
import org.openqa.selenium.internal.seleniumemulation.RunScript;
import org.openqa.selenium.internal.seleniumemulation.ScriptMutator;
import org.openqa.selenium.internal.seleniumemulation.SelectFrame;
import org.openqa.selenium.internal.seleniumemulation.SelectOption;
import org.openqa.selenium.internal.seleniumemulation.SelectPopUp;
import org.openqa.selenium.internal.seleniumemulation.SelectWindow;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;
import org.openqa.selenium.internal.seleniumemulation.SetNextConfirmationState;
import org.openqa.selenium.internal.seleniumemulation.SetTimeout;
import org.openqa.selenium.internal.seleniumemulation.ShiftKeyDown;
import org.openqa.selenium.internal.seleniumemulation.ShiftKeyUp;
import org.openqa.selenium.internal.seleniumemulation.Submit;
import org.openqa.selenium.internal.seleniumemulation.Timer;
import org.openqa.selenium.internal.seleniumemulation.Type;
import org.openqa.selenium.internal.seleniumemulation.TypeKeys;
import org.openqa.selenium.internal.seleniumemulation.Uncheck;
import org.openqa.selenium.internal.seleniumemulation.UseXPathLibrary;
import org.openqa.selenium.internal.seleniumemulation.WaitForCondition;
import org.openqa.selenium.internal.seleniumemulation.WaitForPageToLoad;
import org.openqa.selenium.internal.seleniumemulation.WaitForPopup;
import org.openqa.selenium.internal.seleniumemulation.WindowFocus;
import org.openqa.selenium.internal.seleniumemulation.WindowMaximize;
import org.openqa.selenium.internal.seleniumemulation.Windows;

public class WebDriverCommandProcessor
implements CommandProcessor,
WrapsDriver {
    private final Map<String, SeleneseCommand<?>> seleneseMethods = Maps.newHashMap();
    private final String baseUrl;
    private final Timer timer;
    private final CompoundMutator scriptMutator;
    private Supplier<WebDriver> maker;
    private WebDriver driver;

    public WebDriverCommandProcessor(String baseUrl, WebDriver driver) {
        this(baseUrl, new ExplodingSupplier());
        this.driver = driver;
        this.assertDriverSupportsJavascript(driver);
        this.setUpMethodMap();
    }

    public WebDriverCommandProcessor(String baseUrl, Supplier<WebDriver> maker) {
        this.maker = maker;
        this.baseUrl = baseUrl;
        this.timer = new Timer(30000L);
        this.scriptMutator = new CompoundMutator(baseUrl);
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public String getRemoteControlServerLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String doCommand(String commandName, String[] args) {
        Object val = this.execute(commandName, args);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public void setExtensionJs(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start() {
        this.start((Object)null);
    }

    @Override
    public void start(String s) {
        throw new UnsupportedOperationException("Unsure how to process: " + s);
    }

    @Override
    public void start(Object o) {
        if (this.driver != null) {
            throw new SeleniumException("You may not start more than one session at a time");
        }
        this.driver = this.maker.get();
        this.assertDriverSupportsJavascript(this.driver);
        this.setUpMethodMap();
    }

    @Override
    public void stop() {
        this.timer.stop();
        if (this.driver != null) {
            this.driver.quit();
        }
        this.driver = null;
    }

    @Override
    public String getString(String commandName, String[] args) {
        return (String)this.execute(commandName, args);
    }

    @Override
    public String[] getStringArray(String commandName, String[] args) {
        return (String[])this.execute(commandName, args);
    }

    @Override
    public Number getNumber(String commandName, String[] args) {
        return (Number)this.execute(commandName, args);
    }

    @Override
    public Number[] getNumberArray(String s, String[] strings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String commandName, String[] args) {
        return (Boolean)this.execute(commandName, args);
    }

    @Override
    public boolean[] getBooleanArray(String s, String[] strings) {
        throw new UnsupportedOperationException();
    }

    private Object execute(String commandName, String[] args) {
        SeleneseCommand<?> command = this.seleneseMethods.get(commandName);
        if (command == null) {
            throw new UnsupportedOperationException(commandName);
        }
        return this.timer.run(command, this.driver, args);
    }

    public void addMutator(ScriptMutator mutator) {
        this.scriptMutator.addMutator(mutator);
    }

    public boolean isMethodAvailable(String methodName) {
        return this.seleneseMethods.containsKey(methodName);
    }

    public void addMethod(String methodName, SeleneseCommand<?> command) {
        this.seleneseMethods.put(methodName, command);
    }

    public SeleneseCommand<?> getMethod(String methodName) {
        return this.seleneseMethods.get(methodName);
    }

    @VisibleForTesting
    protected void assertDriverSupportsJavascript(WebDriver driver) {
        if (!(driver instanceof JavascriptExecutor)) {
            throw new IllegalStateException("Driver instance must support JS.");
        }
        if (!(driver instanceof HasCapabilities)) {
            return;
        }
        if (!((HasCapabilities)((Object)driver)).getCapabilities().isJavascriptEnabled()) {
            throw new IllegalStateException("JS support must be enabled.");
        }
    }

    private void setUpMethodMap() {
        JavascriptLibrary javascriptLibrary = new JavascriptLibrary();
        ElementFinder elementFinder = new ElementFinder(javascriptLibrary);
        KeyState keyState = new KeyState();
        AlertOverride alertOverride = new AlertOverride();
        Windows windows = new Windows(this.driver);
        this.seleneseMethods.put("addLocationStrategy", new AddLocationStrategy(elementFinder));
        this.seleneseMethods.put("addSelection", new AddSelection(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("allowNativeXpath", new AllowNativeXPath());
        this.seleneseMethods.put("altKeyDown", new AltKeyDown(keyState));
        this.seleneseMethods.put("altKeyUp", new AltKeyUp(keyState));
        this.seleneseMethods.put("assignId", new AssignId(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("attachFile", new AttachFile(elementFinder));
        this.seleneseMethods.put("captureScreenshotToString", new CaptureScreenshotToString());
        this.seleneseMethods.put("click", new Click(alertOverride, elementFinder));
        this.seleneseMethods.put("clickAt", new ClickAt(alertOverride, elementFinder));
        this.seleneseMethods.put("check", new Check(alertOverride, elementFinder));
        this.seleneseMethods.put("chooseCancelOnNextConfirmation", new SetNextConfirmationState(false));
        this.seleneseMethods.put("chooseOkOnNextConfirmation", new SetNextConfirmationState(true));
        this.seleneseMethods.put("close", new Close());
        this.seleneseMethods.put("createCookie", new CreateCookie());
        this.seleneseMethods.put("controlKeyDown", new ControlKeyDown(keyState));
        this.seleneseMethods.put("controlKeyUp", new ControlKeyUp(keyState));
        this.seleneseMethods.put("deleteAllVisibleCookies", new DeleteAllVisibleCookies());
        this.seleneseMethods.put("deleteCookie", new DeleteCookie());
        this.seleneseMethods.put("deselectPopUp", new DeselectPopUp(windows));
        this.seleneseMethods.put("doubleClick", new DoubleClick(alertOverride, elementFinder));
        this.seleneseMethods.put("dragdrop", new DragAndDrop(elementFinder));
        this.seleneseMethods.put("dragAndDrop", new DragAndDrop(elementFinder));
        this.seleneseMethods.put("dragAndDropToObject", new DragAndDropToObject(elementFinder));
        this.seleneseMethods.put("fireEvent", new FireEvent(elementFinder, javascriptLibrary));
        this.seleneseMethods.put("focus", new FireNamedEvent(elementFinder, javascriptLibrary, "focus"));
        this.seleneseMethods.put("getAlert", new GetAlert(alertOverride));
        this.seleneseMethods.put("getAllButtons", new GetAllButtons());
        this.seleneseMethods.put("getAllFields", new GetAllFields());
        this.seleneseMethods.put("getAllLinks", new GetAllLinks());
        this.seleneseMethods.put("getAllWindowNames", new GetAllWindowNames());
        this.seleneseMethods.put("getAllWindowTitles", new GetAllWindowTitles());
        this.seleneseMethods.put("getAttribute", new GetAttribute(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("getAttributeFromAllWindows", new GetAttributeFromAllWindows());
        this.seleneseMethods.put("getBodyText", new GetBodyText());
        this.seleneseMethods.put("getConfirmation", new GetConfirmation(alertOverride));
        this.seleneseMethods.put("getCookie", new GetCookie());
        this.seleneseMethods.put("getCookieByName", new GetCookieByName());
        this.seleneseMethods.put("getElementHeight", new GetElementHeight(elementFinder));
        this.seleneseMethods.put("getElementIndex", new GetElementIndex(elementFinder, javascriptLibrary));
        this.seleneseMethods.put("getElementPositionLeft", new GetElementPositionLeft(elementFinder));
        this.seleneseMethods.put("getElementPositionTop", new GetElementPositionTop(elementFinder));
        this.seleneseMethods.put("getElementWidth", new GetElementWidth(elementFinder));
        this.seleneseMethods.put("getEval", new GetEval(this.scriptMutator));
        this.seleneseMethods.put("getExpression", new GetExpression());
        this.seleneseMethods.put("getHtmlSource", new GetHtmlSource());
        this.seleneseMethods.put("getLocation", new GetLocation());
        this.seleneseMethods.put("getSelectedId", new FindFirstSelectedOptionProperty(javascriptLibrary, elementFinder, "id"));
        this.seleneseMethods.put("getSelectedIds", new FindSelectedOptionProperties(javascriptLibrary, elementFinder, "id"));
        this.seleneseMethods.put("getSelectedIndex", new FindFirstSelectedOptionProperty(javascriptLibrary, elementFinder, "index"));
        this.seleneseMethods.put("getSelectedIndexes", new FindSelectedOptionProperties(javascriptLibrary, elementFinder, "index"));
        this.seleneseMethods.put("getSelectedLabel", new FindFirstSelectedOptionProperty(javascriptLibrary, elementFinder, "text"));
        this.seleneseMethods.put("getSelectedLabels", new FindSelectedOptionProperties(javascriptLibrary, elementFinder, "text"));
        this.seleneseMethods.put("getSelectedValue", new FindFirstSelectedOptionProperty(javascriptLibrary, elementFinder, "value"));
        this.seleneseMethods.put("getSelectedValues", new FindSelectedOptionProperties(javascriptLibrary, elementFinder, "value"));
        this.seleneseMethods.put("getSelectOptions", new GetSelectOptions(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("getSpeed", new NoOp("0"));
        this.seleneseMethods.put("getTable", new GetTable(elementFinder, javascriptLibrary));
        this.seleneseMethods.put("getText", new GetText(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("getTitle", new GetTitle());
        this.seleneseMethods.put("getValue", new GetValue(elementFinder));
        this.seleneseMethods.put("getXpathCount", new GetXpathCount());
        this.seleneseMethods.put("getCssCount", new GetCssCount());
        this.seleneseMethods.put("goBack", new GoBack());
        this.seleneseMethods.put("highlight", new Highlight(elementFinder, javascriptLibrary));
        this.seleneseMethods.put("isAlertPresent", new IsAlertPresent(alertOverride));
        this.seleneseMethods.put("isChecked", new IsChecked(elementFinder));
        this.seleneseMethods.put("isConfirmationPresent", new IsConfirmationPresent(alertOverride));
        this.seleneseMethods.put("isCookiePresent", new IsCookiePresent());
        this.seleneseMethods.put("isEditable", new IsEditable(elementFinder));
        this.seleneseMethods.put("isElementPresent", new IsElementPresent(elementFinder));
        this.seleneseMethods.put("isOrdered", new IsOrdered(elementFinder, javascriptLibrary));
        this.seleneseMethods.put("isSomethingSelected", new IsSomethingSelected(javascriptLibrary));
        this.seleneseMethods.put("isTextPresent", new IsTextPresent(javascriptLibrary));
        this.seleneseMethods.put("isVisible", new IsVisible(elementFinder));
        this.seleneseMethods.put("keyDown", new KeyEvent(elementFinder, javascriptLibrary, keyState, "doKeyDown"));
        this.seleneseMethods.put("keyPress", new TypeKeys(alertOverride, elementFinder));
        this.seleneseMethods.put("keyUp", new KeyEvent(elementFinder, javascriptLibrary, keyState, "doKeyUp"));
        this.seleneseMethods.put("metaKeyDown", new MetaKeyDown(keyState));
        this.seleneseMethods.put("metaKeyUp", new MetaKeyUp(keyState));
        this.seleneseMethods.put("mouseOver", new MouseEvent(elementFinder, javascriptLibrary, "mouseover"));
        this.seleneseMethods.put("mouseOut", new MouseEvent(elementFinder, javascriptLibrary, "mouseout"));
        this.seleneseMethods.put("mouseDown", new MouseEvent(elementFinder, javascriptLibrary, "mousedown"));
        this.seleneseMethods.put("mouseDownAt", new MouseEventAt(elementFinder, javascriptLibrary, "mousedown"));
        this.seleneseMethods.put("mouseMove", new MouseEvent(elementFinder, javascriptLibrary, "mousemove"));
        this.seleneseMethods.put("mouseMoveAt", new MouseEventAt(elementFinder, javascriptLibrary, "mousemove"));
        this.seleneseMethods.put("mouseUp", new MouseEvent(elementFinder, javascriptLibrary, "mouseup"));
        this.seleneseMethods.put("mouseUpAt", new MouseEventAt(elementFinder, javascriptLibrary, "mouseup"));
        this.seleneseMethods.put("open", new Open(this.baseUrl));
        this.seleneseMethods.put("openWindow", new OpenWindow(this.baseUrl, new GetEval(this.scriptMutator)));
        this.seleneseMethods.put("refresh", new Refresh());
        this.seleneseMethods.put("removeAllSelections", new RemoveAllSelections(elementFinder));
        this.seleneseMethods.put("removeSelection", new RemoveSelection(javascriptLibrary, elementFinder));
        this.seleneseMethods.put("runScript", new RunScript(this.scriptMutator));
        this.seleneseMethods.put("select", new SelectOption(alertOverride, javascriptLibrary, elementFinder));
        this.seleneseMethods.put("selectFrame", new SelectFrame(windows));
        this.seleneseMethods.put("selectPopUp", new SelectPopUp(windows));
        this.seleneseMethods.put("selectWindow", new SelectWindow(windows));
        this.seleneseMethods.put("setBrowserLogLevel", new NoOp(null));
        this.seleneseMethods.put("setContext", new NoOp(null));
        this.seleneseMethods.put("setSpeed", new NoOp(null));
        this.seleneseMethods.put("setTimeout", new SetTimeout(this.timer));
        this.seleneseMethods.put("shiftKeyDown", new ShiftKeyDown(keyState));
        this.seleneseMethods.put("shiftKeyUp", new ShiftKeyUp(keyState));
        this.seleneseMethods.put("submit", new Submit(alertOverride, elementFinder));
        this.seleneseMethods.put("type", new Type(alertOverride, javascriptLibrary, elementFinder, keyState));
        this.seleneseMethods.put("typeKeys", new TypeKeys(alertOverride, elementFinder));
        this.seleneseMethods.put("uncheck", new Uncheck(alertOverride, elementFinder));
        this.seleneseMethods.put("useXpathLibrary", new UseXPathLibrary());
        this.seleneseMethods.put("waitForCondition", new WaitForCondition(this.scriptMutator));
        this.seleneseMethods.put("waitForFrameToLoad", new NoOp(null));
        this.seleneseMethods.put("waitForPageToLoad", new WaitForPageToLoad());
        this.seleneseMethods.put("waitForPopUp", new WaitForPopup(windows));
        this.seleneseMethods.put("windowFocus", new WindowFocus(javascriptLibrary));
        this.seleneseMethods.put("windowMaximize", new WindowMaximize(javascriptLibrary));
    }
}

