/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClasses={HtmlTextArea.class})
public class HTMLTextAreaElement
extends FormField {
    private static final Pattern NORMALIZE_VALUE_PATTERN = Pattern.compile("([^\\r])\\n");

    @Override
    public String getType() {
        return "textarea";
    }

    @Override
    public String getValue() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    @Override
    public void setValue(String value) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setText(value);
    }

    @JsxGetter
    public int getCols() {
        String s = this.getDomNodeOrDie().getAttribute("cols");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_COLS_RETURNS_20)) {
                return 20;
            }
            return -1;
        }
    }

    @JsxSetter
    public void setCols(String cols) {
        int i;
        try {
            i = Float.valueOf(cols).intValue();
            if (i < 0) {
                throw new NumberFormatException("New value for cols smaller than zero.");
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            i = 0;
        }
        this.getDomNodeOrDie().setAttribute("cols", Integer.toString(i));
    }

    @JsxGetter
    public int getRows() {
        int rows;
        try {
            String s = this.getDomNodeOrDie().getAttribute("rows");
            rows = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            rows = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_174) ? -1 : 2;
        }
        return rows;
    }

    @JsxSetter
    public void setRows(String rows) {
        int i;
        try {
            i = new Float(rows).intValue();
            if (i < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_111)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            i = 0;
        }
        this.getDomNodeOrDie().setAttribute("rows", Integer.toString(i));
    }

    @JsxGetter
    public String getDefaultValue() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getDefaultValue();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getSelectionStart() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionStart();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionStart(int start) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionStart(start);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getSelectionEnd() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionEnd();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionEnd(int end) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionEnd(end);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxFunction
    public void select() {
        ((HtmlTextArea)this.getDomNodeOrDie()).select();
    }

    @JsxGetter
    public boolean getReadOnly() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getAccessKey() {
        return super.getAccessKey();
    }

    @Override
    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setAccessKey(String accessKey) {
        super.setAccessKey(accessKey);
    }
}

