/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class SafariOptions
extends AbstractDriverOptions<SafariOptions> {
    static final String SAFARI_TECH_PREVIEW = "Safari Technology Preview";
    @Deprecated
    public static final String CAPABILITY = "safari.options";

    public SafariOptions() {
        this.setUseTechnologyPreview(false);
        this.setCapability("browserName", "safari");
    }

    public SafariOptions(Capabilities source) {
        this();
        source.getCapabilityNames().forEach(name -> this.setCapability((String)name, source.getCapability(name)));
    }

    public SafariOptions merge(Capabilities extraCapabilities) {
        Require.nonNull((String)"Capabilities to merge", (Object)extraCapabilities);
        SafariOptions newInstance = new SafariOptions();
        this.getCapabilityNames().forEach(name -> newInstance.setCapability((String)name, this.getCapability((String)name)));
        extraCapabilities.getCapabilityNames().forEach(name -> newInstance.setCapability((String)name, extraCapabilities.getCapability(name)));
        return newInstance;
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        if (capabilities instanceof SafariOptions) {
            return (SafariOptions)capabilities;
        }
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)((Object)cap);
        }
        if (cap instanceof Map) {
            return new SafariOptions((Capabilities)new MutableCapabilities((Map)cap));
        }
        return new SafariOptions(capabilities);
    }

    public SafariOptions setAutomaticInspection(boolean automaticInspection) {
        this.setCapability("safari:automaticInspection", automaticInspection);
        return this;
    }

    public SafariOptions setAutomaticProfiling(boolean automaticProfiling) {
        this.setCapability("safari:automaticProfiling", automaticProfiling);
        return this;
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        super.setCapability("browserName", useTechnologyPreview ? SAFARI_TECH_PREVIEW : "safari");
        return this;
    }

    public boolean getAutomaticInspection() {
        return Boolean.TRUE.equals(this.getCapability("safari:automaticInspection"));
    }

    public boolean getAutomaticProfiling() {
        return Boolean.TRUE.equals(this.is("safari:automaticProfiling"));
    }

    public boolean getUseTechnologyPreview() {
        return SAFARI_TECH_PREVIEW.equals(this.getBrowserName());
    }

    public Map<String, Object> asMap() {
        TreeMap result = new TreeMap(super.asMap());
        return Collections.unmodifiableMap(result);
    }

    private static interface Option {
        public static final String AUTOMATIC_INSPECTION = "safari:automaticInspection";
        public static final String AUTOMATIC_PROFILING = "safari:automaticProfiling";
    }
}

