/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Collections;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.safari.SafariDriverCommandExecutor;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriver
extends RemoteWebDriver {
    public SafariDriver() {
        this(new SafariOptions());
    }

    @Deprecated
    public SafariDriver(Capabilities desiredCapabilities) {
        this(SafariOptions.fromCapabilities(desiredCapabilities));
    }

    public SafariDriver(SafariOptions safariOptions) {
        this(SafariDriverService.createDefaultService(safariOptions), safariOptions);
    }

    public SafariDriver(SafariDriverService safariService) {
        this(safariService, new SafariOptions());
    }

    public SafariDriver(SafariDriverService safariServer, SafariOptions safariOptions) {
        super((CommandExecutor)new SafariDriverCommandExecutor(safariServer), (Capabilities)safariOptions);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Beta
    public String newWindow(WindowType type) {
        Response response = this.execute("SAFARI_NEW_WINDOW", Collections.singletonMap("newTab", type == WindowType.TAB));
        return (String)response.getValue();
    }

    public static enum WindowType {
        TAB,
        WINDOW;

    }
}

