/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.io.IOUtils;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.safari.BrowserInstallation;

class SafariLocator {
    private static Logger LOG = Logger.getLogger(SafariLocator.class.getName());
    private static final File DEFAULT_SAFARI_PATH = new File("/Applications/Safari.app/Contents/MacOS/Safari");

    SafariLocator() {
    }

    public String launcherFilePath() {
        return this.findBrowserLocationOrFail().launcherFilePath();
    }

    public BrowserInstallation findBrowserLocationOrFail() {
        BrowserInstallation location = this.findBrowserLocation();
        if (null == location) {
            throw new RuntimeException("Safari could not be found in the path!\nPlease add the directory containing 'Safari' to your PATH environment\nvariable, or explicitly specify a path to Safari.");
        }
        return location;
    }

    public BrowserInstallation findBrowserLocation() {
        LOG.fine("Discovering Safari...");
        BrowserInstallation defaultPath = this.findAtADefaultLocation();
        if (null != defaultPath) {
            return defaultPath;
        }
        return this.findFileInPath("Safari");
    }

    protected BrowserInstallation findAtADefaultLocation() {
        String userProvidedDefaultPath = System.getProperty(this.browserPathOverridePropertyName());
        if (null != userProvidedDefaultPath) {
            return this.retrieveValidInstallationPath(userProvidedDefaultPath);
        }
        BrowserInstallation validInstallationPath = this.retrieveValidInstallationPath(DEFAULT_SAFARI_PATH);
        if (null != validInstallationPath) {
            return validInstallationPath;
        }
        return null;
    }

    public BrowserInstallation findFileInPath(String fileName) {
        return this.retrieveValidInstallationPath(CommandLine.find(fileName));
    }

    public BrowserInstallation retrieveValidInstallationPath(String launcher) {
        if (null == launcher) {
            return null;
        }
        return this.retrieveValidInstallationPath(new File(launcher));
    }

    protected BrowserInstallation retrieveValidInstallationPath(File launcher) {
        if (null == launcher) {
            return null;
        }
        LOG.fine("Checking whether Safari launcher at :'" + launcher + "' is valid...");
        if (!launcher.exists()) {
            return null;
        }
        if (this.isScriptFile(launcher)) {
            LOG.warning("Caution: '" + launcher.getAbsolutePath() + "': file is a script file, not a real executable.  The browser environment is no longer fully under RC control");
        }
        LOG.fine("Discovered valid Safari launcher  : '" + launcher + "'");
        return new BrowserInstallation(launcher.getAbsolutePath());
    }

    protected boolean isScriptFile(File aFile) {
        boolean bl;
        FileReader reader;
        char[] firstTwoChars;
        block5: {
            firstTwoChars = new char[2];
            reader = null;
            reader = new FileReader(aFile);
            int charsRead = reader.read(firstTwoChars);
            if (2 == charsRead) break block5;
            boolean bl2 = false;
            IOUtils.closeQuietly(reader);
            return bl2;
        }
        try {
            bl = firstTwoChars[0] == '#' && firstTwoChars[1] == '!';
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return bl;
    }

    protected String browserPathOverridePropertyName() {
        return "SafariDefaultPath";
    }
}

