/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.session;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.session.CapabilitiesFilter;

public class FirefoxFilter
implements CapabilitiesFilter {
    @Override
    public Map<String, Object> apply(Map<String, Object> unmodifiedCaps) {
        Map caps = unmodifiedCaps.entrySet().parallelStream().filter(entry -> "browserName".equals(entry.getKey()) && Browser.FIREFOX.is(String.valueOf(entry.getValue())) || ((String)entry.getKey()).startsWith("firefox_") || ((String)entry.getKey()).startsWith("moz:")).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, r) -> l, TreeMap::new));
        if (unmodifiedCaps.containsKey("marionette") && !caps.containsKey("browserName")) {
            caps.put("browserName", "firefox");
        }
        TreeMap<String, Object> options = unmodifiedCaps.getOrDefault("moz:firefoxOptions", new TreeMap());
        options = new TreeMap<String, Object>((Map<String, Object>)options);
        if (unmodifiedCaps.containsKey("firefox_binary") && !options.containsKey("binary")) {
            options.put("binary", unmodifiedCaps.get("firefox_binary"));
        }
        if (unmodifiedCaps.containsKey("firefox_profile") && !options.containsKey("profile")) {
            options.put("profile", unmodifiedCaps.get("firefox_profile"));
        }
        if (!options.isEmpty()) {
            caps.put("moz:firefoxOptions", options);
        }
        return caps.isEmpty() ? null : caps;
    }
}

