/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.StackFrame;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class StackTrace {
    private final List<StackFrame> callFrames;

    private StackTrace(List<StackFrame> callFrames) {
        this.callFrames = callFrames;
    }

    public List<StackFrame> getCallFrames() {
        return this.callFrames;
    }

    public static StackTrace fromJson(JsonInput input) {
        List callFrames = Collections.emptyList();
        input.beginObject();
        while (input.hasNext()) {
            if ("callFrames".equals(input.nextName())) {
                callFrames = (List)input.readNonNull(new TypeToken<List<StackFrame>>(){}.getType());
                continue;
            }
            input.skipValue();
        }
        input.endObject();
        return new StackTrace(callFrames);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, List<StackFrame>> toReturn = new TreeMap<String, List<StackFrame>>();
        toReturn.put("callFrames", this.callFrames);
        return Collections.unmodifiableMap(toReturn);
    }
}

