/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.script.LocalValue;

public class RemoteReference
extends LocalValue {
    private final @Nullable String handle;
    private final @Nullable String sharedId;

    public RemoteReference(String handle, String sharedId) {
        this.handle = handle;
        this.sharedId = sharedId;
    }

    public RemoteReference(Type type, String value) {
        if (Type.HANDLE.equals((Object)type)) {
            this.handle = value;
            this.sharedId = null;
        } else {
            this.sharedId = value;
            this.handle = null;
        }
    }

    @Override
    public Map<String, Object> toJson() {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        if (this.handle != null) {
            toReturn.put(Type.HANDLE.toString(), this.handle);
        }
        if (this.sharedId != null) {
            toReturn.put(Type.SHARED_ID.toString(), this.sharedId);
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public static enum Type {
        HANDLE("handle"),
        SHARED_ID("sharedId");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

