/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.math.BigInteger;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.script.ArrayLocalValue;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.DateLocalValue;
import org.openqa.selenium.bidi.script.MapLocalValue;
import org.openqa.selenium.bidi.script.ObjectLocalValue;
import org.openqa.selenium.bidi.script.PrimitiveProtocolValue;
import org.openqa.selenium.bidi.script.PrimitiveType;
import org.openqa.selenium.bidi.script.RegExpValue;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;
import org.openqa.selenium.bidi.script.SetLocalValue;
import org.openqa.selenium.json.Json;

public abstract class LocalValue {
    private static final Json JSON = new Json();

    public abstract Map<String, Object> toJson();

    public static LocalValue stringValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.STRING, value);
    }

    public static LocalValue numberValue(long value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(double value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(SpecialNumberType specialNumber) {
        return new PrimitiveProtocolValue(PrimitiveType.SPECIAL_NUMBER, specialNumber.toString());
    }

    public static LocalValue undefinedValue() {
        return new PrimitiveProtocolValue(PrimitiveType.UNDEFINED);
    }

    public static LocalValue nullValue() {
        return new PrimitiveProtocolValue(PrimitiveType.NULL);
    }

    public static LocalValue booleanValue(boolean value) {
        return new PrimitiveProtocolValue(PrimitiveType.BOOLEAN, value);
    }

    public static LocalValue bigIntValue(BigInteger value) {
        return LocalValue.bigIntValue(value.toString());
    }

    public static LocalValue bigIntValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.BIGINT, value);
    }

    public static LocalValue listToLocalValues(List<Object> rawValues) {
        List<LocalValue> values = rawValues.stream().map(value -> LocalValue.getArgument(value)).collect(Collectors.toList());
        return LocalValue.arrayValue(values);
    }

    public static LocalValue arrayValue(List<LocalValue> value) {
        return new ArrayLocalValue(value);
    }

    public static LocalValue dateValue(Instant value) {
        return LocalValue.dateValue(value.toString());
    }

    public static LocalValue dateValue(String value) {
        return new DateLocalValue(value);
    }

    public static LocalValue mapToLocalValues(Map<Object, Object> rawValues) {
        Map<Object, LocalValue> map = rawValues.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey() instanceof String ? entry.getKey() : LocalValue.getArgument(entry.getKey()), entry -> LocalValue.getArgument(entry.getValue())));
        return LocalValue.mapValue(map);
    }

    public static LocalValue mapValue(Map<Object, LocalValue> value) {
        return new MapLocalValue(value);
    }

    public static LocalValue objectValue(Map<Object, LocalValue> value) {
        return new ObjectLocalValue(value);
    }

    public static LocalValue regExpValue(String pattern) {
        return new RegExpValue(pattern);
    }

    public static LocalValue regExpValue(String pattern, String flags) {
        return new RegExpValue(pattern, flags);
    }

    public static LocalValue setToLocalValues(Set<Object> rawValues) {
        Set<LocalValue> values = rawValues.stream().map(value -> LocalValue.getArgument(value)).collect(Collectors.toSet());
        return LocalValue.setValue(values);
    }

    public static LocalValue setValue(Set<LocalValue> value) {
        return new SetLocalValue(value);
    }

    public static LocalValue channelValue(String channelId) {
        return new ChannelValue(channelId);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options) {
        return new ChannelValue(channelId, options);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options, ResultOwnership resultOwnership) {
        return new ChannelValue(channelId, options, resultOwnership);
    }

    public static LocalValue remoteReference(String handle, String sharedId) {
        return new RemoteReference(handle, sharedId);
    }

    public static LocalValue remoteReference(RemoteReference.Type type, String id) {
        return new RemoteReference(type, id);
    }

    public static LocalValue getArgument(@Nullable Object arg) {
        if (arg == null) {
            return LocalValue.nullValue();
        }
        if (arg instanceof String) {
            return LocalValue.stringToLocalValue((String)arg);
        }
        if (arg instanceof Number) {
            return LocalValue.numberToLocalValue((Number)arg);
        }
        if (arg instanceof Boolean) {
            return LocalValue.booleanValue((Boolean)arg);
        }
        if (arg instanceof Instant) {
            return LocalValue.dateValue((Instant)arg);
        }
        if (arg instanceof Map) {
            return LocalValue.mapToLocalValues((Map)arg);
        }
        if (arg instanceof List) {
            return LocalValue.listToLocalValues((List)arg);
        }
        if (arg instanceof Set) {
            return LocalValue.setToLocalValues((Set)arg);
        }
        if (arg instanceof RegExpValue) {
            return (RegExpValue)arg;
        }
        Map rawValues = (Map)JSON.toType(JSON.toJson(arg), Map.class);
        Map<Object, LocalValue> map = rawValues.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey() instanceof String ? entry.getKey() : LocalValue.getArgument(entry.getKey()), entry -> LocalValue.getArgument(entry.getValue())));
        return LocalValue.objectValue(map);
    }

    private static LocalValue stringToLocalValue(String arg) {
        switch (arg) {
            case "undefined": {
                return LocalValue.undefinedValue();
            }
            case "null": {
                return LocalValue.nullValue();
            }
            case "-Infinity": {
                return LocalValue.numberValue(SpecialNumberType.MINUS_INFINITY);
            }
            case "Infinity": {
                return LocalValue.numberValue(SpecialNumberType.INFINITY);
            }
            case "NaN": {
                return LocalValue.numberValue(SpecialNumberType.NAN);
            }
            case "-0": {
                return LocalValue.numberValue(SpecialNumberType.MINUS_ZERO);
            }
        }
        return LocalValue.stringValue(arg);
    }

    private static LocalValue numberToLocalValue(Number arg) {
        if (arg instanceof BigInteger) {
            return LocalValue.bigIntValue((BigInteger)arg);
        }
        if (arg instanceof Double || arg instanceof Float) {
            return LocalValue.numberValue(arg.doubleValue());
        }
        return LocalValue.numberValue(arg.longValue());
    }

    public static enum SpecialNumberType {
        NAN("NaN"),
        MINUS_ZERO("-0"),
        INFINITY("Infinity"),
        MINUS_INFINITY("-Infinity");

        private final String type;

        private SpecialNumberType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

