/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Map;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;

public class ChannelValue
extends LocalValue {
    private final String channelId;
    private final @Nullable SerializationOptions options;
    private final @Nullable ResultOwnership resultOwnership;

    public ChannelValue(String channelId) {
        this(channelId, null, null);
    }

    public ChannelValue(String channelId, SerializationOptions options) {
        this(channelId, options, null);
    }

    public ChannelValue(String channelId, ResultOwnership resultOwnership) {
        this(channelId, null, resultOwnership);
    }

    ChannelValue(String channelId, @Nullable SerializationOptions options, @Nullable ResultOwnership resultOwnership) {
        this.channelId = channelId;
        this.options = options;
        this.resultOwnership = resultOwnership;
    }

    @Override
    public Map<String, Object> toJson() {
        TreeMap<String, Object> channelProperties = new TreeMap<String, Object>();
        channelProperties.put("channel", this.channelId);
        if (this.options != null) {
            channelProperties.put("serializationOptions", this.options);
        }
        if (this.resultOwnership != null) {
            channelProperties.put("ownership", (Object)this.resultOwnership);
        }
        return Map.of("type", "channel", "value", channelProperties);
    }
}

