/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class Cookie {
    private final String name;
    private final BytesValue value;
    private final @Nullable String domain;
    private final @Nullable String path;
    private final @Nullable Long size;
    private final boolean isSecure;
    private final boolean isHttpOnly;
    private final @Nullable SameSite sameSite;
    private final Optional<Long> expiry;

    public Cookie(String name, BytesValue value, @Nullable String domain, @Nullable String path, @Nullable Long size, boolean isSecure, boolean httpOnly, @Nullable SameSite sameSite, Optional<Long> expiry) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.size = size;
        this.isSecure = isSecure;
        this.isHttpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expiry = expiry;
    }

    public static Cookie fromJson(JsonInput input) {
        String name = null;
        BytesValue value = null;
        String domain = null;
        String path = null;
        Long size = null;
        boolean isSecure = false;
        boolean isHttpOnly = false;
        SameSite sameSite = null;
        Optional<Long> expiry = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = (String)input.read(String.class);
                    continue block22;
                }
                case "value": {
                    value = (BytesValue)input.read(BytesValue.class);
                    continue block22;
                }
                case "domain": {
                    domain = (String)input.read(String.class);
                    continue block22;
                }
                case "path": {
                    path = (String)input.read(String.class);
                    continue block22;
                }
                case "size": {
                    size = (Long)input.read(Long.class);
                    continue block22;
                }
                case "secure": {
                    isSecure = (Boolean)input.readNonNull(Boolean.class);
                    continue block22;
                }
                case "httpOnly": {
                    isHttpOnly = (Boolean)input.readNonNull(Boolean.class);
                    continue block22;
                }
                case "sameSite": {
                    String sameSiteValue = (String)input.readNonNull(String.class);
                    sameSite = SameSite.findByName(sameSiteValue);
                    continue block22;
                }
                case "expiry": {
                    expiry = Optional.of((Long)input.readNonNull(Long.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Cookie((String)Require.nonNull((String)"name", name), (BytesValue)Require.nonNull((String)"value", value), domain, path, size, isSecure, isHttpOnly, sameSite, expiry);
    }

    public String getName() {
        return this.name;
    }

    public BytesValue getValue() {
        return this.value;
    }

    public @Nullable String getDomain() {
        return this.domain;
    }

    public @Nullable String getPath() {
        return this.path;
    }

    public @Nullable Long getSize() {
        return this.size;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public @Nullable SameSite getSameSite() {
        return this.sameSite;
    }

    public Optional<Long> getExpiry() {
        return this.expiry;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.getName());
        map.put("value", this.getValue().toMap());
        if (this.domain != null) {
            map.put("domain", this.domain);
        }
        if (this.path != null) {
            map.put("path", this.path);
        }
        if (this.size != null) {
            map.put("size", this.size);
        }
        map.put("secure", this.isSecure());
        map.put("httpOnly", this.isHttpOnly());
        if (this.sameSite != null) {
            map.put("sameSite", this.sameSite.toString());
        }
        this.expiry.ifPresent(expiry -> map.put("expiry", expiry));
        return Collections.unmodifiableMap(map);
    }

    public static enum SameSite {
        STRICT("strict"),
        LAX("lax"),
        NONE("none"),
        DEFAULT("default");

        private final String type;

        private SameSite(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static SameSite findByName(String name) {
            for (SameSite type : SameSite.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unsupported \"SameSite\" attribute: " + name);
        }
    }
}

