/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.Map;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class BytesValue {
    private final Type type;
    private final String value;

    public BytesValue(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public static BytesValue fromJson(JsonInput input) {
        Type type = null;
        String value = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    String bytesValue = (String)input.readNonNull(String.class);
                    type = bytesValue.equals(Type.BASE64.toString()) ? Type.BASE64 : Type.STRING;
                    continue block8;
                }
                case "value": {
                    value = (String)input.read(String.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BytesValue((Type)((Object)Require.nonNull((String)"type", type)), (String)Require.nonNull((String)"value", value));
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> toMap() {
        return Map.of("type", this.type.toString(), "value", this.value);
    }

    public static enum Type {
        STRING("string"),
        BASE64("base64");

        private final String bytesValueType;

        private Type(String type) {
            this.bytesValueType = type;
        }

        public String toString() {
            return this.bytesValueType;
        }
    }
}

