/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browser.ClientWindowInfo;
import org.openqa.selenium.bidi.browser.SetDownloadBehaviorParameters;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    private final BiDi bidi;
    private static final Function<JsonInput, String> userContextInfoMapper = json -> (String)json.readMapElement("userContext");
    private static final Function<JsonInput, List<String>> userContextsInfoMapper = json -> {
        List userContexts = (List)json.readMapElement("userContexts");
        return userContexts.stream().map(map -> (String)map.get("userContext")).collect(Collectors.toList());
    };
    private static final Function<JsonInput, List<ClientWindowInfo>> clientWindowsInfoMapper = json -> {
        List clientWindows = (List)json.readMapElement("clientWindows");
        return clientWindows.stream().map(map -> ClientWindowInfo.fromJson(map)).collect(Collectors.toList());
    };

    public Browser(WebDriver driver) {
        this.bidi = ((HasBiDi)driver).getBiDi();
    }

    public String createUserContext() {
        return this.bidi.send(new Command<String>("browser.createUserContext", Map.of(), userContextInfoMapper));
    }

    public List<String> getUserContexts() {
        return this.bidi.send(new Command<List<String>>("browser.getUserContexts", Map.of(), userContextsInfoMapper));
    }

    public void removeUserContext(String userContext) {
        this.bidi.send(new Command("browser.removeUserContext", Map.of("userContext", userContext)));
    }

    public List<ClientWindowInfo> getClientWindows() {
        return this.bidi.send(new Command<List<ClientWindowInfo>>("browser.getClientWindows", Map.of(), clientWindowsInfoMapper));
    }

    public void setDownloadBehavior(SetDownloadBehaviorParameters parameters) {
        this.bidi.send(new Command("browser.setDownloadBehavior", parameters.toMap()));
    }
}

