/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class StackFrame {
    private final String url;
    private final String functionName;
    private final int lineNumber;
    private final int columnNumber;

    public StackFrame(String scriptUrl, String function, int lineNumber, int columnNumber) {
        this.url = scriptUrl;
        this.functionName = function;
        this.lineNumber = Require.nonNegative((String)"Line number", (Integer)lineNumber);
        this.columnNumber = Require.nonNegative((String)"Column number", (Integer)columnNumber);
    }

    public String getUrl() {
        return this.url;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public static StackFrame fromJson(JsonInput input) {
        String url = null;
        String functionName = null;
        Integer lineNumber = null;
        Integer columnNumber = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = (String)input.read(String.class);
                    continue block12;
                }
                case "functionName": {
                    functionName = (String)input.read(String.class);
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = (Integer)input.read(Integer.class);
                    continue block12;
                }
                case "columnNumber": {
                    columnNumber = (Integer)input.read(Integer.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackFrame((String)Require.nonNull((String)"URL", url), (String)Require.nonNull((String)"Function name", functionName), (Integer)Require.nonNull((String)"Line number", (Object)lineNumber), (Integer)Require.nonNull((String)"Column number", (Object)columnNumber));
    }
}

