/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.CaptureScreenshotParameters;
import org.openqa.selenium.bidi.browsingcontext.CreateContextParameters;
import org.openqa.selenium.bidi.browsingcontext.LocateNodeParameters;
import org.openqa.selenium.bidi.browsingcontext.Locator;
import org.openqa.selenium.bidi.browsingcontext.NavigationResult;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.print.PrintOptions;

public class BrowsingContext {
    private static final Json JSON = new Json();
    private final String id;
    private final BiDi bidi;
    private static final String CONTEXT = "context";
    private static final String RELOAD = "browsingContext.reload";
    private static final String HANDLE_USER_PROMPT = "browsingContext.handleUserPrompt";
    private static final Function<JsonInput, String> browsingContextIdMapper = json -> json.readMap().getOrDefault(CONTEXT, "").toString();
    private static final Function<JsonInput, NavigationResult> navigationInfoMapper = json -> (NavigationResult)json.readNonNull(NavigationResult.class);
    private static final Function<JsonInput, List<BrowsingContextInfo>> browsingContextInfoListMapper = json -> {
        Type type = new TypeToken<Map<String, List<BrowsingContextInfo>>>(){}.getType();
        Map result = (Map)json.readNonNull(type);
        return result.getOrDefault("contexts", Collections.emptyList());
    };
    private static final Function<JsonInput, List<RemoteValue>> nodesMapper = json -> {
        Type type = new TypeToken<Map<String, List<RemoteValue>>>(){}.getType();
        Map result = (Map)json.readNonNull(type);
        return (List)result.get("nodes");
    };

    public BrowsingContext(WebDriver driver, String id) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing Context id", (Object)id);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        Require.precondition((!id.isEmpty() ? 1 : 0) != 0, (String)"Browsing Context id cannot be empty", (Object[])new Object[0]);
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = id;
    }

    public BrowsingContext(WebDriver driver, WindowType type) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"WindowType", (Object)type);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type);
    }

    public BrowsingContext(WebDriver driver, CreateContextParameters parameters) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"CreateContextParameters", (Object)parameters);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(parameters);
    }

    public String getId() {
        return this.id;
    }

    private String create(WindowType type) {
        return this.bidi.send(new Command<String>("browsingContext.create", Map.of("type", type.toString()), browsingContextIdMapper));
    }

    private String create(CreateContextParameters parameters) {
        return this.bidi.send(new Command<String>("browsingContext.create", parameters.toMap(), browsingContextIdMapper));
    }

    public NavigationResult navigate(String url) {
        return this.navigate(url, ReadinessState.NONE);
    }

    public NavigationResult navigate(String url, ReadinessState readinessState) {
        return this.bidi.send(this.navigateCommand(url, readinessState));
    }

    public NavigationResult navigate(String url, ReadinessState readinessState, Duration timeout) {
        return this.bidi.send(this.navigateCommand(url, readinessState), timeout);
    }

    private Command<NavigationResult> navigateCommand(String url, ReadinessState readinessState) {
        return new Command<NavigationResult>("browsingContext.navigate", Map.of(CONTEXT, this.id, "url", url, "wait", readinessState.toString()), navigationInfoMapper);
    }

    public List<BrowsingContextInfo> getTree() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id), browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(String root) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", root), browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id, "maxDepth", maxDepth), browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(String root, int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", root, "maxDepth", maxDepth), browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTopLevelContexts() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", new HashMap<String, Object>(), browsingContextInfoListMapper));
    }

    public NavigationResult reload() {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id), navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache), navigationInfoMapper));
    }

    public NavigationResult reload(ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "wait", readinessState.toString()), navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache, "wait", readinessState.toString()), navigationInfoMapper));
    }

    public void handleUserPrompt() {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id)));
    }

    public void handleUserPrompt(boolean accept) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept)));
    }

    public void handleUserPrompt(String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "userText", userText)));
    }

    public void handleUserPrompt(boolean accept, String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept, "userText", userText)));
    }

    public String captureScreenshot() {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id), jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public String captureScreenshot(CaptureScreenshotParameters parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CONTEXT, this.id);
        params.putAll(parameters.toMap());
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", params, jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public String captureBoxScreenshot(double x, double y, double width, double height) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "box", "x", x, "y", y, "width", width, "height", height)), jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public String captureElementScreenshot(String elementId) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId))), jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public String captureElementScreenshot(String elementId, String handle) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId, "handle", handle))), jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public void setViewport(int width, int height) {
        this.setViewport(Double.valueOf(width), Double.valueOf(height));
    }

    public void setViewport(int width, int height, double devicePixelRatio) {
        this.setViewport(Double.valueOf(width), Double.valueOf(height), (Double)devicePixelRatio);
    }

    public void setViewport(@Nullable Double width, @Nullable Double height) {
        this.validate(width, height);
        HashMap<String, @Nullable Object> params = new HashMap<String, Object>();
        params.put(CONTEXT, this.id);
        params.put("viewport", width == null ? null : Map.of("width", width, "height", Objects.requireNonNull(height)));
        this.bidi.send(new Command("browsingContext.setViewport", params));
    }

    public void setViewport(@Nullable Double width, @Nullable Double height, @Nullable Double devicePixelRatio) {
        this.validate(width, height);
        this.validate(devicePixelRatio);
        HashMap<String, @Nullable Object> params = new HashMap<String, Object>();
        params.put(CONTEXT, this.id);
        params.put("viewport", width == null ? null : Map.of("width", width, "height", Objects.requireNonNull(height)));
        params.put("devicePixelRatio", devicePixelRatio);
        this.bidi.send(new Command("browsingContext.setViewport", params));
    }

    private void validate(@Nullable Double width, @Nullable Double height) {
        if (width != null || height != null) {
            Require.positive((String)"Viewport width", (Double)width);
            Require.positive((String)"Viewport height", (Double)height);
        }
    }

    private void validate(@Nullable Double devicePixelRatio) {
        if (devicePixelRatio != null) {
            Require.positive((String)"Device pixel ratio.", (Double)devicePixelRatio);
        }
    }

    public void activate() {
        this.bidi.send(new Command("browsingContext.activate", Map.of(CONTEXT, this.id)));
    }

    public String print(PrintOptions printOptions) {
        Map printOptionsParams = printOptions.toMap();
        printOptionsParams.put(CONTEXT, this.id);
        return this.bidi.send(new Command<String>("browsingContext.print", (Map<String, Object>)printOptionsParams, jsonInput -> (String)jsonInput.readMap().get("data")));
    }

    public void traverseHistory(long delta) {
        this.bidi.send(new Command("browsingContext.traverseHistory", Map.of(CONTEXT, this.id, "delta", delta)));
    }

    public void back() {
        this.traverseHistory(-1L);
    }

    public void forward() {
        this.traverseHistory(1L);
    }

    public List<RemoteValue> locateNodes(LocateNodeParameters parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>(parameters.toMap());
        params.put(CONTEXT, this.id);
        return this.bidi.send(new Command<List<RemoteValue>>("browsingContext.locateNodes", params, nodesMapper));
    }

    public List<RemoteValue> locateNodes(Locator locator) {
        return this.bidi.send(new Command<List<RemoteValue>>("browsingContext.locateNodes", Map.of(CONTEXT, this.id, "locator", locator.toMap()), nodesMapper));
    }

    public RemoteValue locateNode(Locator locator) {
        List<RemoteValue> remoteValues = this.bidi.send(new Command<List<RemoteValue>>("browsingContext.locateNodes", Map.of(CONTEXT, this.id, "locator", locator.toMap(), "maxNodeCount", 1), nodesMapper));
        return remoteValues.get(0);
    }

    public void close() {
        this.bidi.send(new Command("browsingContext.close", Map.of(CONTEXT, this.id)));
    }
}

