/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.storage.DeleteCookiesParameters;
import org.openqa.selenium.bidi.storage.GetCookiesParameters;
import org.openqa.selenium.bidi.storage.GetCookiesResult;
import org.openqa.selenium.bidi.storage.PartitionKey;
import org.openqa.selenium.bidi.storage.SetCookieParameters;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class Storage {
    private static final Json JSON = new Json();
    private final BiDi bidi;
    private final Function<JsonInput, GetCookiesResult> getCookiesResultMapper = jsonInput -> (GetCookiesResult)jsonInput.read(GetCookiesResult.class);
    private final Function<JsonInput, PartitionKey> partitionKeyResultMapper = jsonInput -> {
        Map response = (Map)jsonInput.read(Map.class);
        try (StringReader reader = new StringReader(JSON.toJson(response.get("partitionKey")));){
            PartitionKey partitionKey;
            block11: {
                JsonInput input = JSON.newInput((Reader)reader);
                try {
                    partitionKey = (PartitionKey)input.read(PartitionKey.class);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return partitionKey;
        }
    };

    public Storage(WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
    }

    public GetCookiesResult getCookies(GetCookiesParameters params) {
        return this.bidi.send(new Command<GetCookiesResult>("storage.getCookies", params.toMap(), this.getCookiesResultMapper));
    }

    public PartitionKey setCookie(SetCookieParameters params) {
        return this.bidi.send(new Command<PartitionKey>("storage.setCookie", params.toMap(), this.partitionKeyResultMapper));
    }

    public PartitionKey deleteCookies(DeleteCookiesParameters params) {
        return this.bidi.send(new Command<PartitionKey>("storage.deleteCookies", params.toMap(), this.partitionKeyResultMapper));
    }
}

