/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.ExternalProcess;
import org.openqa.selenium.remote.service.DriverFinder;

public class DriverService
implements Closeable {
    public static final String LOG_NULL = "/dev/null";
    public static final String LOG_STDERR = "/dev/stderr";
    public static final String LOG_STDOUT = "/dev/stdout";
    private static final String NAME = "Driver Service Executor";
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(20L);
    private static final Logger LOG = Logger.getLogger(DriverService.class.getName());
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread = new Thread(r);
        thread.setName(NAME);
        thread.setDaemon(true);
        return thread;
    });
    private final URL url;
    private String executable;
    private final ReentrantLock lock = new ReentrantLock();
    private final Duration timeout;
    private final List<String> args;
    private final Map<String, String> environment;
    protected ExternalProcess process = null;
    private OutputStream outputStream = System.err;

    protected DriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        if (executable != null) {
            this.executable = executable.getCanonicalPath();
        }
        this.timeout = timeout;
        this.args = args;
        this.environment = environment;
        this.url = this.getUrl(port);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    protected List<String> getArgs() {
        return this.args;
    }

    protected Map<String, String> getEnvironment() {
        return this.environment;
    }

    protected URL getUrl(int port) throws IOException {
        return new URL(String.format("http://localhost:%d", port));
    }

    protected Capabilities getDefaultDriverOptions() {
        return new ImmutableCapabilities();
    }

    protected String getDriverName() {
        return null;
    }

    public String getDriverProperty() {
        return null;
    }

    protected File getDriverExecutable() {
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.process != null && this.process.isAlive();
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            if (this.executable == null) {
                if (this.getDefaultDriverOptions().getBrowserName().isEmpty()) {
                    throw new WebDriverException("Driver executable is null and browser name is not set.");
                }
                this.executable = new DriverFinder(this, this.getDefaultDriverOptions()).getDriverPath();
            }
            LOG.fine(String.format("Starting driver at %s with %s", this.executable, this.args));
            ExternalProcess.Builder builder = ExternalProcess.builder().command(this.executable, this.args).copyOutputTo(this.getOutputStream());
            this.environment.forEach((arg_0, arg_1) -> ((ExternalProcess.Builder)builder).environment(arg_0, arg_1));
            this.process = builder.start();
            CompletableFuture<StartOrDie> serverStarted = CompletableFuture.supplyAsync(() -> {
                this.waitUntilAvailable();
                return StartOrDie.SERVER_STARTED;
            }, this.executorService);
            CompletableFuture<StartOrDie> processFinished = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.process.waitFor(this.getTimeout()) ? StartOrDie.PROCESS_DIED : StartOrDie.PROCESS_IS_ACTIVE;
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }, this.executorService);
            try {
                StartOrDie status = (StartOrDie)((Object)CompletableFuture.anyOf(serverStarted, processFinished).get(this.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS));
                if (status == null) {
                    throw new InterruptedException();
                }
                switch (status.ordinal()) {
                    case 0: {
                        processFinished.cancel(true);
                        break;
                    }
                    case 2: {
                        this.process = null;
                        throw new WebDriverException("Driver server process died prematurely.");
                    }
                    case 1: {
                        this.process.shutdown();
                        throw new WebDriverException("Timed out waiting for driver server to bind the port.");
                    }
                }
            }
            catch (ExecutionException e) {
                this.process.shutdown();
                throw new WebDriverException("Failed waiting for driver server to start.", (Throwable)e);
            }
            catch (TimeoutException e) {
                this.process.shutdown();
                throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.process.shutdown();
                Thread.currentThread().interrupt();
                throw new WebDriverException("Interrupted while waiting for driver server to start.", (Throwable)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Duration getTimeout() {
        return this.timeout;
    }

    protected void waitUntilAvailable() {
        try {
            URL status = new URL(this.url.toString() + "/status");
            new UrlChecker().waitUntilAvailable(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS, new URL[]{status});
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Driver server status URL is malformed.", (Throwable)e);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        WebDriverException toThrow = null;
        try {
            if (this.process == null) {
                return;
            }
            if (this.hasShutdownEndpoint()) {
                try {
                    URL killUrl = new URL(this.url.toString() + "/shutdown");
                    new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
                    try {
                        this.process.waitFor(Duration.ofSeconds(10L));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (MalformedURLException e) {
                    toThrow = new WebDriverException((Throwable)e);
                }
                catch (UrlChecker.TimeoutException e) {
                    toThrow = new WebDriverException("Timed out waiting for driver server to shutdown.", (Throwable)e);
                }
            }
            this.process.shutdown();
            if (this.getOutputStream() instanceof FileOutputStream) {
                try {
                    this.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
            this.close();
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    protected boolean hasShutdownEndpoint() {
        return true;
    }

    public void sendOutputTo(OutputStream outputStream) {
        this.outputStream = (OutputStream)Require.nonNull((String)"Output stream", (Object)outputStream);
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        ExecutorServices.shutdownGracefully(NAME, this.executorService);
    }

    private static enum StartOrDie {
        SERVER_STARTED,
        PROCESS_IS_ACTIVE,
        PROCESS_DIED;

    }

    public static abstract class Builder<DS extends DriverService, B extends Builder<?, ?>> {
        private int port = 0;
        private File exe = null;
        private Map<String, String> environment = Collections.emptyMap();
        private File logFile;
        private Duration timeout;
        private OutputStream logOutputStream;

        public abstract int score(Capabilities var1);

        public B usingDriverExecutable(File file) {
            Require.nonNull((String)"Driver executable file", (Object)file);
            this.exe = file;
            return (B)this;
        }

        public B usingPort(int port) {
            this.port = Require.nonNegative((String)"Port number", (Integer)port);
            return (B)this;
        }

        protected int getPort() {
            return this.port;
        }

        public B usingAnyFreePort() {
            this.port = 0;
            return (B)this;
        }

        @Beta
        public B withEnvironment(Map<String, String> environment) {
            this.environment = Map.copyOf(environment);
            return (B)this;
        }

        public B withLogFile(File logFile) {
            this.logFile = logFile;
            return (B)this;
        }

        public B withLogOutput(OutputStream output) {
            this.logOutputStream = output;
            return (B)this;
        }

        protected File getLogFile() {
            return this.logFile;
        }

        public B withTimeout(Duration timeout) {
            this.timeout = timeout;
            return (B)this;
        }

        protected Duration getDefaultTimeout() {
            return DEFAULT_TIMEOUT;
        }

        protected OutputStream getLogOutput() {
            if (this.logOutputStream != null) {
                return this.logOutputStream;
            }
            try {
                File logFile = this.getLogFile();
                return logFile == null ? OutputStream.nullOutputStream() : new FileOutputStream(logFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        protected void parseLogOutput(String logProperty) {
            String logLocation;
            if (this.getLogFile() != null || this.logOutputStream != null) {
                return;
            }
            switch (logLocation = System.getProperty(logProperty, DriverService.LOG_NULL)) {
                case "/dev/stdout": {
                    this.withLogOutput(System.out);
                    break;
                }
                case "/dev/stderr": {
                    this.withLogOutput(System.err);
                    break;
                }
                case "/dev/null": {
                    this.withLogOutput(OutputStream.nullOutputStream());
                    break;
                }
                default: {
                    this.withLogFile(new File(logLocation));
                }
            }
        }

        public DS build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.timeout == null) {
                this.timeout = this.getDefaultTimeout();
            }
            this.loadSystemProperties();
            List<String> args = this.createArgs();
            DS service = this.createDriverService(this.exe, this.port, this.timeout, args, this.environment);
            ((DriverService)service).sendOutputTo(this.getLogOutput());
            this.port = 0;
            return service;
        }

        protected abstract void loadSystemProperties();

        protected abstract List<String> createArgs();

        protected abstract DS createDriverService(File var1, int var2, Duration var3, List<String> var4, Map<String, String> var5);
    }
}

